const fs = require('fs');
const path = require('path');
const crypto = require('crypto');

const baseDir = __dirname;
const modulesDir = path.join(baseDir, 'modules');
const assetsDir = path.join(baseDir, 'img');

const data = [];

// Функция для генерации хеша содержимого файла
function generateHash(filePath) {
    const fileContent = fs.readFileSync(filePath);
    return crypto.createHash('md5').update(fileContent).digest('hex').substring(0, 8);
}

// Рекурсивная функция для получения всех файлов в директории
function getAllFiles(dirPath, ext = ['.html', '.css', '.js'], arrayOfFiles = []) {
    const files = fs.readdirSync(dirPath);

    files.forEach(function (file) {
        const filePath = path.join(dirPath, file);
        if (fs.statSync(filePath).isDirectory()) {
            arrayOfFiles = getAllFiles(filePath, ext, arrayOfFiles);
        } else if (ext.includes(path.extname(file))) {
            arrayOfFiles.push(filePath);
        }
    });

    return arrayOfFiles;
}

// Функция для обновления ссылок с добавлением хеша
function addHashToLinks(filePath) {
    let content = fs.readFileSync(filePath, 'utf8');
	const resultData = {file:filePath,lines:[]};
    const regexPatterns = [
        /(\.\.\/\.\.\/img\/[^\s\)]+?\.(svg|png|jpg|ico))/g, // CSS background images
        /(import\s.*?['"]\.\.\/helpers\.js)(\?ver=\d+)?/g,   // JS imports
        /(import\s.*?['"].*?\/([^/]+\.js))(\?ver=\d+)?/g,    // JS module imports
        /(href\s*=\s*["'].*?\/([^/]+\.css))(\?ver=\d+)?/g,   // CSS files in HTML
        /(src\s*=\s*["'].*?\/([^/]+\.js))(\?ver=\d+)?/g      // JS files in HTML
    ];

    regexPatterns.forEach((pattern) => {
        content = content.replace(pattern, (match, p1, p2, p3) => {
			console.log('filePath:', filePath, 'p1: ', p1, 'P2: ', p2, 'P3: ', p3);
			console.log('content: ', content);
            //const targetPath = path.join(baseDir, p1);
			//console.log('targetPath: ', targetPath);
            //if (fs.existsSync(targetPath)) {
                //const hash = generateHash(targetPath);
				//var result = `${p1}?ver=${hash}`;
				//console.log('hash', hash, result);
                //return result;
            //}
            //return match;
        });
    });

    //fs.writeFileSync(filePath, content, 'utf8');
}

// Основная функция для обновления всех файлов проекта
function updateAllFiles() {
    const allFiles = getAllFiles(baseDir);

    allFiles.forEach((file) => {
        addHashToLinks(file);
        //console.log(`Updated hashes in: ${file}`);
    });
}

// Запуск скрипта
updateAllFiles();
