import { loadTemplate } from "../helpers.js?ver=1";

export default class AudioPlayerMenu{
	
	constructor(service, player){
		this.service= service;
		this.content = null;
		this.menu = null;
		this.appMenu = null;
		this.cardItem = null;
		this.bookList = null;
		this.bookListData = null;
		this.player = player;
		this.body = null;
		
		this.init();
	}
	
	async init(){
		
		try{
			this.content = await loadTemplate('audioPlayerMenu');
			this.menu = this.content.cloneNode(true);
			document.body.append(this.menu);
			
			this.initElements();
			this.initEventListeners();
			
			this.appMenu = this.menu.querySelector('#app-menu');
			this.bookList = this.menu.querySelector('#book-list');
			
			const cardItem = this.menu.querySelector('.card');
			this.cardItem = cardItem.cloneNode(true);
			cardItem.remove();
			
			this.menu.addEventListener('hidden.bs.offcanvas', event => {
				this.clearList();
				this.unselectItems();
			});
			
		} catch (error) {
            console.error('Ошибка загрузки шаблона:', error);
        }
	}
	
	async initElements() {
        const elements = [
            'searchText', 'searchBtn', 'allBooks', 'lastTenLoaded', 'lastTenNotOpen',
			'lastTenOpened','currentCycle'
        ];
        
        elements.forEach(el => this[el] = this.menu.querySelector(`#${el}`));
		
		this.body = this.menu.querySelector(".offcanvas-body");
    }
	
	async initEventListeners() {
		this.searchText.addEventListener('click', () => this.selectItem(this.searchText));
		this.searchBtn.addEventListener('click', () => this.search(this.searchText.value));
		this.allBooks.addEventListener('click', () => this.getAllBooks(this.allBooks));
		this.lastTenLoaded.addEventListener('click', () => this.getLastTenLoaded(this.lastTenLoaded));
		
		if(this.player.auth.isAuth()){
			this.lastTenNotOpen.addEventListener('click', () => this.getLastTenNotOpen(this.lastTenNotOpen));
			this.lastTenOpened.addEventListener('click', () => this.getLastTenOpened(this.lastTenOpened));
			this.currentCycle.addEventListener('click', () => this.getCurrentCycle(this.currentCycle));
		}else{
			[...this.menu.querySelectorAll('.only-auth')].forEach(item =>
				item.remove()
			);
		}
	}
	
	async selectItem(obj){
		this.unselectItems();
		obj.classList.add('selected-item');
	}
	
	async unselectItems(){
		[...this.menu.querySelectorAll('.selected-item')].forEach(item => 
            item.classList.toggle('selected-item')
        );
	}
	
	async search(text) {
		try {
			this.bookList.innerHTML = '';
			this.bookListData = await this.service.serarchBooks(text);
			this.buildItems(this.bookListData);
		} catch (error) {
			console.error('Ошибка при поиске книг:', error);
		}
	}
	
	async getAllBooks(ctrl){
		try {
			this.searchText.value = '';
			this.selectItem(ctrl);
			this.bookListData = await this.service.getBookList();
			this.buildItems(this.bookListData);
		} catch (error) {
			console.error('Ошибка при поиске книг:', error);
		}
	}
	
	async getLastTenLoaded(ctrl){
		try {
			this.searchText.value = '';
			this.selectItem(ctrl);
			this.bookListData = await this.service.getLastTenBooks();
			this.buildItems(this.bookListData);
		} catch (error) {
			console.error('Ошибка при поиске книг:', error);
		}
	}
	
	async getLastTenNotOpen(ctrl){
		try {
			this.searchText.value = '';
			this.selectItem(ctrl);
			this.bookListData = await this.service.getLastTenNotOppenedBooks();
			this.buildItems(this.bookListData);
		} catch (error) {
			console.error('Ошибка при поиске книг:', error);
		}
	}
	
	async getLastTenOpened(ctrl){
		try {
			this.searchText.value = '';
			this.selectItem(ctrl);
			this.bookListData = await this.service.getlastTenOpened();
			this.buildItems(this.bookListData);
		} catch (error) {
			console.error('Ошибка при поиске книг:', error);
		}
	}
	
	async getCurrentCycle(ctrl){
		try {
			this.searchText.value = '';
			this.selectItem(ctrl);
			this.bookListData = await this.service.getCurrentCycleBooks();
			this.buildItems(this.bookListData);
		} catch (error) {
			console.error('Ошибка при поиске книг:', error);
		}
	}

	async buildItems(data) {
		try {
			this.bookList.innerHTML = ''; // Очищаем текущий список
			data.forEach(el => this.buildItem(el));
			const btn = document.createElement('button');
			btn.type = 'button';
			btn.classList.add('btn');
			btn.classList.add('btn-up');
			
			this.bookList.append(btn);
			
			btn.addEventListener('click', () => {
				console.log('up');
				this.body.scrollTo({
				  top: 0,
				  behavior: 'smooth' // плавный переход
				});
			});
			
		} catch (error) {
			console.error('Ошибка при создании списка книг:', error);
		}
	}

	async buildItem(item) {
		if (!this.cardItem) {
			console.error('Элемент cardItem не инициализирован');
			return;
		}
		const card = this.cardItem.cloneNode(true);
		card.querySelector('.card-img-top').src = `${this.service.url}/${item.img}`;
		card.querySelector('.book-name').innerHTML = item.name;
		card.querySelector('.author').innerHTML = item.author;
		card.querySelector('.ganre').innerHTML = item.ganre;
		card.querySelector('.time').innerHTML = item.duration;
		card.querySelector('.reader').innerHTML = item.reader;
		
		if(this.player.bookId == item.id)
		{
			card.classList.add('selected');
		}
		else if(item.opened == 0)
		{
			card.classList.add('not-opened');
		}
		
		this.bookList.append(card);
		
		card.addEventListener('click', () => {this.player.getPlayList(item.id); document.querySelector('.offcanvas .btn-close').click();});
	}
	
	async clearList(){
		this.bookList.innerHTML = '';
		this.searchText.value = '';
		this.bookListData = null;
	}
}