import { loadTemplate } from "../helpers.js?ver=1";

export default class Auth{
		
	constructor(){
		this.container = null;
		
		this.player = null;
		this.userIdCookie = 'userid';
        this.cookieExpiryDays = 365;
        this.signInButtonId = 'gSignIn';
		
		this.initExternalScripts();
		this.init();
	}	
		
	async initExternalScripts(){
		// Add the Google API script
		const googleScript = document.createElement('script');
		googleScript.src = "https://apis.google.com/js/client:platform.js?onload=renderButton";
		googleScript.async = true;
		googleScript.defer = true;
		document.head.appendChild(googleScript);
		

		// Add the Google Sign-In meta tag
		const metaTag = document.createElement('meta');
		metaTag.name = "google-signin-client_id";
		metaTag.content = "903732126131-6d6opgjsjbmvkn7ah35shrdu5j0rdh8d.apps.googleusercontent.com";
		document.head.appendChild(metaTag);
	}
		
	async init(){
		const content = await loadTemplate('auth');
		this.container = content.cloneNode(true);
		document.body.append(this.container);
	}	
	
	async setPlayer(player){
		this.player = player;
	}
	
	isAuth(){
		const value = this.getCookie(this.userIdCookie); 
		const result = value? true : false;
		
		return result;
	}
	
	// Set a cookie with expiration days
    setCookie(cname, cvalue, exdays = this.cookieExpiryDays) {
        const d = new Date();
        d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
        document.cookie = `${cname}=${cvalue};expires=${d.toUTCString()};path=/`;
    }

    // Get a cookie value by name
    getCookie(cname) {
        const name = `${cname}=`;
        return document.cookie.split(';').map(c => c.trim()).find(c => c.startsWith(name))?.substring(name.length) || "";
    }

    // Render the Google Sign-In button or load the last book if already authenticated
    renderButton(openBook) {
		
        const userId = this.getCookie(this.userIdCookie);
        if (openBook) {
            this.player.loadPlayList(openBook);
        } else if (userId) {
			setTimeout(() => this.player.initData(userId), 300);
        } else {
			
			setTimeout(() => 
            gapi.signin2.render(this.signInButtonId, {
                'scope': 'profile email',
                'width': 245,
                'height': 50,
                'longtitle': true,
                'theme': 'dark',
                'onsuccess': this.onSuccess.bind(this),
                'onfailure': this.onFailure.bind(this)
            }), 300);
        }
    }

    // On successful Google Sign-In, set the user cookie and load the last book
    onSuccess(googleUser) {
        gapi.client.load('oauth2', 'v2', () => {
            gapi.client.oauth2.userinfo.get({ 'userId': 'me' }).execute(resp => {
                this.setCookie(this.userIdCookie, resp.email);
                this.player.initData(resp.email);
                document.getElementById(this.signInButtonId).style.display = "none";
            });
        });
    }

    // Handle Google Sign-In failure
    async onFailure(error) {
        alert(error);
    }

    // Sign out the user and remove the userId cookie
    signOut() {
        const auth2 = gapi.auth2.getAuthInstance();
        auth2.signOut().then(() => {
            document.getElementById(this.signInButtonId).style.display = "block";
        });
        auth2.disconnect();
    }

    // Manual login by setting the userId cookie and loading the last book
    login(email) {
        this.setCookie(this.userIdCookie, email);
        this.service.loadLastBook(email, (res) => {
            if (!res) {
                this.setCookie(this.userIdCookie, '', -10); // Clear cookie if no response
            }
        });
        document.getElementById(this.signInButtonId).style.display = "none";
    }
}
