import { loadTemplate } from "../helpers.js?ver=1";

export default class BookService {
	constructor(url, notification) {
		this.email = null;
		this.url = url;
		this.loading = null,
		this.notification = notification;
		
		this.init();
	}
	
	async init(){
		const content = await loadTemplate('bookService');
		this.loading = content.cloneNode(true);
		document.body.append(this.loading);
	}
	
	async setEmail(email){
		this.email = email;
	}
	
	async doRequest(request, err, loading=true){

		try {
			if(loading){
				this.loading.style.display = 'block';
			}
			
			const response = await fetch(request, {
				headers: {
					'Content-Type': 'application/json'
				}
			});
			
			if (!response.ok) {
				this.loading.style.display = 'none';
				throw new Error(response.statusText);
			}
			
			const result = await response.json();
			
			this.loading.style.display = 'none';
			
			return result;
		} catch (error) {
			console.error('err', err, error);
			this.loading.style.display = 'none';
			this.notification.showNotification(error, 'error');
			throw error;
		}
	}
	
	async setPlayTime(data){
		var request = `${this.url}/setPlayTime?email=${this.email}&bookId=${data.bookId}&fileNum=${data.file}&time=${data.time}`;
		var result = this.doRequest(request, 'Failed to set play time:', false);
		
		return result;
	}

	async getLastTime() {
		var tick = new Date().getTime();
		var request = `${this.url}/getLastTime?email=${this.email}&tick=${tick}`;
		var result = this.doRequest(request, 'Failed to set play time:');
		
		return result;
	}

	async getBookList() {
		var request = `${this.url}/getBookList?email=${this.email}`;
		var result = this.doRequest(request, 'Failed to fetch book list:');
		
		return result;
	}

	async getPlayList(bookid) {
		var request = `${this.url}/getPlayList?id=${bookid}&email=${this.email}`;
		var result = this.doRequest(request, 'Failed to fetch playlist:');
		
		return result;
	}
	
	async getLastTenBooks() {
		var request = `${this.url}/getLastTenBooks?email=${this.email}`;
		var result = this.doRequest(request, 'Failed to fetch last ten books:');
		
		return result;
	}
	
	async getLastTenNotOppenedBooks() {
		var request = `${this.url}/getLastTenNotOppenedBooks?email=${this.email}`;
		var result = this.doRequest(request, 'Failed to fetch last ten not opened books:');
		
		return result;
	}
	
	async getlastTenOpened() {
		var request = `${this.url}/getlastTenOpened?email=${this.email}`;
		var result = this.doRequest(request, 'Failed to fetch last ten opened books:');
		
		return result;
	}
	
	async getCurrentCycleBooks() {
		var request = `${this.url}/getCurrentCycleBooks?email=${this.email}`;
		var result = this.doRequest(request, 'Failed to fetch current cycle books:');
		
		return result;
	}
	
	async serarchBooks(search) {
		var request = `${this.url}/serarchBooks?search=${search}&email=${this.email}`;
		var result = this.doRequest(request, 'Failed to fetch search books:');
		
		return result;
	}
}
