export async function loadTemplate(templateName) {
    const response = await fetch(`./modules/${templateName}/${templateName}.html?ver=4`);

    if (!response.ok) {
        throw new Error(`Не удалось загрузить шаблон: ${templateName}`);
    }

	const linkElement = document.createElement('link');
	linkElement.rel = 'stylesheet';
	linkElement.href = `./modules/${templateName}/${templateName}.css?ver=4`;

	// Добавляем в <head>2
	document.head.appendChild(linkElement);

    // Создаем буфер для декодирования текста как UTF-8
    const arrayBuffer = await response.arrayBuffer();
    const templateText = new TextDecoder('utf-8').decode(arrayBuffer);

    const templateElement = document.createElement('div');
    templateElement.innerHTML = templateText.trim();
    return templateElement.firstElementChild;
}

export async function loadTemplatewebpack(templateName) {
    let template;
    let style;

    switch (templateName) {
        case 'audioPlayer':
            style = await import(`./modules/audioPlayer/audioPlayer.css`);
            template = await import(`./modules/audioPlayer/audioPlayer.html`);
            break;
        case 'audioPlayerMenu':
            style = await import(`./modules/audioPlayerMenu/audioPlayerMenu.css`);
            template = await import(`./modules/audioPlayerMenu/audioPlayerMenu.html`);
            break;
		case 'bookService':
            style = await import(`./modules/bookService/bookService.css`);
            template = await import(`./modules/bookService/bookService.html`);
            break;
		case 'notification':
            style = await import(`./modules/notification/notification.css`);
            template = await import(`./modules/notification/notification.html`);
            break;
        // Добавьте остальные модули аналогично
        default:
            throw new Error(`Template not found: ${templateName}`);
    }

    const templateElement = document.createElement('div');
    templateElement.innerHTML = template.default.trim();
    return templateElement.firstElementChild;
}