import { loadTemplate } from "../helpers.js?ver=1";

export default class Notification{
	constructor(){
		this.container = null;
		
		this.init();
	}
	
	async init(){
		const content = await loadTemplate('notification');
		this.container = content.cloneNode(true);
		document.body.append(this.container);
	}
	
	async showNotification(message, type = 'info', duration = 3000) {
		
		// Create notification element
		const notification = document.createElement('div');
		notification.className = `notification ${type}`;
		notification.textContent = message;
		
		// Add it to the container and apply animation class
		this.container.appendChild(notification);
		requestAnimationFrame(() => notification.classList.add('show'));

		// Remove notification after the duration
		setTimeout(() => this.hide(notification), duration);
		
		notification.addEventListener('click', () => this.hide(notification));
	}
	
	async hide(notification){
		notification.classList.remove('show');
		notification.addEventListener('transitionend', () => {
			notification.remove();
		});
	}
}

// Usage examples
//showNotification('This is an info message.', 'info');
//showNotification('This is a success message.', 'success');
//showNotification('This is an error message.', 'error');
//showNotification('This is a warning message.', 'warning');
