<?php

error_reporting(E_ALL);
ini_set("display_errors", 1);
require_once 'Helpers/AppHelper.php';


class Admin_Controller {

    public function index($args = '') {
        Helper::loadView('Admin');
    }

    public function getAuthors($args = '') {
        $db = Helper::loadModel('AdminBooksDb');

        return Helper::json($db->getAuthors());
    }

    public function getGanres($args = '') {
        $db = Helper::loadModel('AdminBooksDb');

        return Helper::json($db->getGanres());
    }

    public function getReaders($args = '') {
        $db = Helper::loadModel('AdminBooksDb');

        return Helper::json($db->getReaders());
    }

	public function getPath($args=''){
		$result = array();
		if ($handle = opendir(TORRENT_FOLDER_PATH . '/' . $args['path'])) {
			while (false !== ($entry = readdir($handle))) {
				if($entry == '.' || $entry == '..')
					continue;
				
				$type = is_dir(TORRENT_FOLDER_PATH . '/' . $args['path'] . '/' . $entry)? 'folder': 'file';
				$stat = stat(TORRENT_FOLDER_PATH . '/' . $args['path'] . '/' . $entry);
				$result[] = array('name' => $entry, 'type' => $type, 'ctime' => $stat['ctime']);
			}

			closedir($handle);
		}
		
		return Helper::json($result);
	}

    public function getTorrentInfo()
    {
		$data = AppHelper::getTorrentInfo();
	
		//return Helper::json($data);
		return implode("<br>",$data);
    }

    public function getPublishs($args = '') {
        $db = Helper::loadModel('AdminBooksDb');

        return Helper::json($db->getPublishs());
    }

    public function getDowloadTorrentFolder($args = '')
    {
	$fld = is_array($args)? '/' . $args['folder'] : '';
	$dir = TORRENT_FOLDER_PATH . $fld;
	$fileList = AppHelper::getDowloadsTorrentFolder($dir);

	return Helper::json($fileList);
    }

    public function addBook($args = '') {
        $book = Helper::loadModel('LoadBook');

        $data = $book->getBookInfo($args['url']);

        $strData = Helper::json($data);

        $_SESSION['book_data'] = $strData;

        return $strData;
    }

    public function applyBook($args = '') {
        $result = false;
        
        if (isset($_SESSION['book_data'])) {
            $db = Helper::loadModel('AdminBooksDb');
            $data = json_decode($_SESSION['book_data'], true);

            if ($data['status'] == 'OK') {
                $idBook = $db->addBook($data['data']);

                if($idBook !== false)
                {
                    $len = count($data['data']['fileLst']);

                    for ($i = 0; $i < $len; $i++) {
                        $db->setFile(array(
                            'name' => $data['data']['fileLst'][$i]['title'],
                            'source' => $data['data']['fileLst'][$i]['file'],
                            'bookid' => $idBook,
                            'fileNum' => $i + 1
                        ));
                    }
                }
            }
            unset($_SESSION['book_data']);
            $result = true;
        }
        
        return Helper::json($result);
    }
	
	public function applyBookFiles($args='')
	{
		$data = json_decode($args['data'],true);
		
		//print_r($data);
		
		$db = Helper::loadModel('AdminBooksDb');
		$len = count($data['files']);
		for($i = 0; $i < $len; $i++)
		{
			$matches = array();
			preg_match("/\/([0-9]*.mp3)$/",$data['files'][$i]['name'],$matches);
			$db->setFile(array(
				'name' => $matches[1],
				'source' => $data['directory'] . '/' . $data['files'][$i]['name'],
				'bookid' => $data['bookid'],
				'fileNum' => $i + 1
			));
		}
		
		$db->setBookStatus($data['bookid'], 4);
	}
    
    public function getFilesQueue($args='')
    {
        $db = Helper::loadModel('AdminBooksDb');

        return Helper::json($db->getFilesQueue());
    }

    public function getQueueStatus()
    {
		$db = Helper::loadModel('AdminBooksDb');

        return Helper::json($db->getQueueStatus());
    }
    
	public function getTorrentQueue($args='')
    {
		$db = Helper::loadModel('AdminBooksDb');

        return Helper::json($db->getTorrentQueue($args));
	}
	
    public function setQueueFiles($args='')
    {   
        $vals = explode("," ,$args['ids']);
        $sqlArgs = array('bookids' => array(), 'fileids' => array());
        foreach($vals as $val)
        {
            $a = explode("|", $val);
            
            
            if(!in_array($a[0], $sqlArgs['bookids']))
            {
                $sqlArgs['bookids'][] = $a[0];
            }
            
            if(count($a) > 1)
            {
                if(!in_array($a[1], $sqlArgs['fileids']))
                {
                    $sqlArgs['fileids'][] = $a[1];
                }
            }
        }
        
        
        //return Helper::json($sqlArgs);
        $db = Helper::loadModel('AdminBooksDb');

        return Helper::json($db->setQueueFiles($sqlArgs));
    }
	
	public function updateBookInfo($args='')
	{
		$db = Helper::loadModel('AdminBooksDb');
		
		$db->updateBook($args);
		
		$data = $db->getBook($args['id']);
        
        return Helper::json($data);
	}
	
	public function addAuthor($args='')
	{
		$db = Helper::loadModel('AdminBooksDb');
        
        $db->insertAuthor($args);
        
		return Helper::json($db->getAuthors());
	}
    
	public function updateAuthor($args='')
	{
		$db = Helper::loadModel('AdminBooksDb');
        
        $db->updateAuthor($args);
        
		return Helper::json($db->getAuthors());
	}
	
	public function updateGanre($args='')
	{
		$db = Helper::loadModel('AdminBooksDb');
        
        $db->updateGanre($args);
        
		return Helper::json($db->getGanres());
	}
	
	public function addGanre($args='')
	{
		$db = Helper::loadModel('AdminBooksDb');
        
        $db->insertGanre($args);
        
		return Helper::json($db->getGanres());
	}
	
	public function updatePublish($args='')
	{
		$db = Helper::loadModel('AdminBooksDb');
        
        $db->updatePublish($args);
        
		return Helper::json($db->getPublishs());
	}
	
	public function addPublish($args='')
	{
		$db = Helper::loadModel('AdminBooksDb');
        
        $db->insertPublish($args);
        
		return Helper::json($db->getPublishs());
	}
	
	public function updateReader($args='')
	{
		$db = Helper::loadModel('AdminBooksDb');
        
        $db->updateReader($args);
        
		return Helper::json($db->getReaders());
	}
	
	public function addReader($args='')
	{
		$db = Helper::loadModel('AdminBooksDb');
        
        $db->insertReader($args);
        
		return Helper::json($db->getReaders());
	}
	
    public function getBooksList($args='')
    {
        $db = Helper::loadModel('AdminBooksDb');
        
        $data = $db->getBooksList();
        
        return Helper::json($data);
    }
	
	public function updateBookName($args='')
	{
		$db = Helper::loadModel('AdminBooksDb');
		
		$db->updateBookName($args);
		
		return Helper::json($db->getBooksList());
	}
    
    public function getBook($args='')
    {
        $db = Helper::loadModel('AdminBooksDb');
        
        $data = $db->getBook($args['id']);
        
        return Helper::json($data);
    }
    
    public function getFilesInfo($args='')
    {
        $db = Helper::loadModel('AdminBooksDb');
        
        $data = $db->getFilesInfo($args['id']);
        
        return Helper::json($data);
    }
    
    public function getCycleBooks($args='')
    {
        $db = Helper::loadModel('AdminBooksDb');
        
        $data = $db->getCycleBooks();
        
        return Helper::json($data);
    }
    
    public function updateCycleBook($args='')
    {
        $db = Helper::loadModel('AdminBooksDb');
        
        $db->updateCycleBook($args);
        
        return Helper::json($db->getCycleBooks());
    }
    
    public function addCycleBook($args='')
    {
        $db = Helper::loadModel('AdminBooksDb');
        
        $db->insertCycleBook($args);
        
        return Helper::json($db->getCycleBooks());
    }

    public function updateOrderFiles($args='')
    {
	$db = Helper::loadModel('AdminBooksDb');

        $db->updateOrderFiles($args);

        return Helper::json(true);
    }
}
