<?php

function lexa_ci_utf8_like($mask, $value) {
    $mask = str_replace(
            array("%", "_"), array(".*?", "."), preg_quote($mask, "/")
    );
    $mask = "/^$mask$/ui";
    return preg_match($mask, $value);
}

class AdminBooksDB_Model {
    
    private $db;
    private $isConnrcted;
    
    CONST Noname = 'Неизвестно';
    
    public function __construct() {
        try {
            $this->db = new PDO(CONNECTION_STRING, USER, PASSWORD);
            $this->db->sqliteCreateFunction('like', "lexa_ci_utf8_like", 2);
            $this->isConnected = true;
        } catch (PDOException $e) {
            $this->isConnected = false;
        }
    }
    
    public function getBooksList($args='')
    {
        $query = "select b.id as value, b.name as text, a.name as [group] from books b join author a on a.id=b.authorId order by b.authorId, b.cycleId, b.orderId";
        $sth = $this->db->prepare($query);
        
        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();

        return $sth->fetchAll();
    }
    
    public function getBook($args=-1)
    {
        $query = "select * from books where id=?";
        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $args, PDO::PARAM_INT);
        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();

        return $sth->fetch();
    }
    
    public function updateBook($args='')
    {
        $query = "update books set name=?,description=?,authorId=?,ganreId=?,year=?,readerId=?,publishId=?,time=?,img=?,cycleId=?,orderId=?,playlist=? where id=?";
        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $args['name'], PDO::PARAM_STR);
        $sth->bindParam(2, $args['description'], PDO::PARAM_STR);
        $sth->bindParam(3, $args['authorId'], PDO::PARAM_INT);
        $sth->bindParam(4, $args['ganreId'], PDO::PARAM_INT);
        $sth->bindParam(5, $args['year'], PDO::PARAM_INT);
        $sth->bindParam(6, $args['readerId'], PDO::PARAM_INT);
        $sth->bindParam(7, $args['publishId'], PDO::PARAM_INT);
        $sth->bindParam(8, $args['time'], PDO::PARAM_STR);
        $sth->bindParam(9, $args['img'], PDO::PARAM_STR);
        $sth->bindParam(10, $args['cycleId'], PDO::PARAM_INT);
        $sth->bindParam(11, $args['orderId'], PDO::PARAM_INT);
		$sth->bindParam(12, $args['playList'], PDO::PARAM_STR);
        $sth->bindParam(13, $args['id'], PDO::PARAM_INT);
        
        return $sth->execute();
    }
	
	public function updateBookName($args='')
    {
		$query = "update books set name=? where id=?";
        $sth = $this->db->prepare($query);
		$sth->bindParam(1, $args['name'], PDO::PARAM_STR);
		$sth->bindParam(2, $args['id'], PDO::PARAM_INT);
		
		return $sth->execute();
	}
    
    public function getAuthors($args='')
    {
        $query = "select id as value, name as text from author order by name";
        $sth = $this->db->prepare($query);
        
        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();

        return $sth->fetchAll();
    }
    
    public function updateAuthor($args='')
    {
        $query = "update author set name=? where id=?";
        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $args['name'], PDO::PARAM_STR);
        $sth->bindParam(2, $args['id'], PDO::PARAM_INT);
        
        return $sth->execute();
    }
    
    public function insertAuthor($args='')
    {
        $query = "insert into author(name) values(?)";
        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $args['name'], PDO::PARAM_STR);
        
        $res = $sth->execute();

        if ($res == 1) {
            return $this->db->lastInsertId('id');
        }
        
        return -1;
    }
   
    public function getReaders($args='')
    {
        $query = "select id as value, name as text from reader order by name";
        $sth = $this->db->prepare($query);
        
        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();

        return $sth->fetchAll();
    }
    
    public function updateReader($args='')
    {
        $query = "update reader set name=? where id=?";
        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $args['name'], PDO::PARAM_STR);
        $sth->bindParam(2, $args['id'], PDO::PARAM_INT);
        
        return $sth->execute();
    }
    
    public function insertReader($args='')
    {
        $query = "insert into reader(name) values(?)";
        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $args['name'], PDO::PARAM_STR);
        
        $res = $sth->execute();

        if ($res == 1) {
            return $this->db->lastInsertId('id');
        }
        
        return -1;
    }
    
    public function getGanres($args='')
    {
        $query = "select id as value, name as text from ganre order by name";
        $sth = $this->db->prepare($query);
        
        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();

        return $sth->fetchAll();
    }
    
    public function updateGanre($args='')
    {
        $query = "update ganre set name=? where id=?";
        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $args['name'], PDO::PARAM_STR);
        $sth->bindParam(2, $args['id'], PDO::PARAM_INT);
        
        return $sth->execute();
    }
    
    public function insertGanre($args='')
    {
        $query = "insert into ganre(name) values(?)";
        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $args['name'], PDO::PARAM_STR);
        
        $res = $sth->execute();

        if ($res == 1) {
            return $this->db->lastInsertId('id');
        }
        
        return -1;
    }
     
    public function getPublishs($args='')
    {
        $query = "select id as value, name as text from publish order by name";
        $sth = $this->db->prepare($query);
        
        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();

        return $sth->fetchAll();
    }
    
    public function updatePublish($args='')
    {
        $query = "update publish set name=? where id=?";
        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $args['name'], PDO::PARAM_STR);
        $sth->bindParam(2, $args['id'], PDO::PARAM_INT);
        
        return $sth->execute();
    }
    
    public function insertPublish($args='')
    {
        $query = "insert into publish(name) values(?)";
        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $args['name'], PDO::PARAM_STR);
        
        $res = $sth->execute();

        if ($res == 1) {
            return $this->db->lastInsertId('id');
        }
        
        return -1;
    }
    
    public function getCycleBooks($args='')
    {
        $query = "select c.id as value, c.name as text, a.id as authorId from cycleBook c join author a on c.authorId=a.id order by c.name";
        $sth = $this->db->prepare($query);
        
        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();

        return $sth->fetchAll();
    }
    
    public function updateCycleBook($args='')
    {
        $query = "update cycleBook set authorId=?, name=? where id=?";
        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $args['authorId'], PDO::PARAM_INT);
        $sth->bindParam(2, $args['name'], PDO::PARAM_STR);
        $sth->bindParam(3, $args['id'], PDO::PARAM_INT);
        
        return $sth->execute();
    }
    
    public function insertCycleBook($args='')
    {
        $query = "insert into cycleBook(authorId,name) values(?,?)";
        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $args['authorId'], PDO::PARAM_INT);
        $sth->bindParam(2, $args['name'], PDO::PARAM_STR);
        
        $res = $sth->execute();

        if ($res == 1) {
            return $this->db->lastInsertId('id');
        }
        
        return -1;
    }
    
    public function addBook($info) {
        $authorId = $this->getAuthorId($info['author']);

        $query = "SELECT Id From books WHERE authorId=? and name=?";
        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $authorId, PDO::PARAM_INT);
        $sth->bindParam(2, $info['name'], PDO::PARAM_STR);
        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();

        if ($sth->fetch()) {
            return false;
        }

        $ganreId = $this->getGanreId($info['ganre']);
        $readerId = $this->getReaderId($info['reader']);
        $publishId = $this->getPublishId($info['publish']);
        $cycleId = $this->getCycleBookId($authorId, $info['cycle']);

        $query = "INSERT INTO books(name, description, authorId, ganreId, year, readerId, source, playlist, publishId, time, img, cycleId, orderId, status, torrent) values(?,?,?,?,?,?,?,?,?,?,?,?,?,0,?)";
        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $info['name'], PDO::PARAM_STR);
        $sth->bindParam(2, $info['description'], PDO::PARAM_STR);
        $sth->bindParam(3, $authorId, PDO::PARAM_INT);
        $sth->bindParam(4, $ganreId, PDO::PARAM_INT);
        $sth->bindParam(5, $info['year'], PDO::PARAM_INT);
        $sth->bindParam(6, $readerId, PDO::PARAM_INT);
        $sth->bindParam(7, $info['source'], PDO::PARAM_STR);
        $sth->bindParam(8, $info['playList'], PDO::PARAM_STR);
        $sth->bindParam(9, $readerId, PDO::PARAM_INT);
        $sth->bindParam(10, $info['time'], PDO::PARAM_STR);
        $sth->bindParam(11, $info['img'], PDO::PARAM_STR);
        $sth->bindParam(12, $cycleId, PDO::PARAM_INT);
        $sth->bindParam(13, $info['numCycle'], PDO::PARAM_INT);
	$sth->bindParam(14, $info['torrent'], PDO::PARAM_STR);

        $res = $sth->execute();

        if ($res == 1) {
            return $this->db->lastInsertId('id');
        }

        return -1;
    }
    
        public function getAuthorId($name) {
        $name = trim($name);
        if ($name == '') {
            $name = AdminBooksDB_Model::Noname;
        }

        $query = 'SELECT id FROM author WHERE name=?';

        try {
            $sth = $this->db->prepare($query);
            $sth->bindParam(1, $name, PDO::PARAM_STR);
            $sth->setFetchMode(PDO::FETCH_ASSOC);
            $sth->execute();

            $rows = $sth->fetch();

            if ($rows) {
                return $rows['id'];
            } else {
                $query = "INSERT INTO author(name) values(?)";

                $sth = $this->db->prepare($query);
                $sth->bindParam(1, $name, PDO::PARAM_STR);

                $res = $sth->execute();

                $id = -1;

                if ($res == 1) {
                    $id = $this->db->lastInsertId('id');
                }

                return $id;
            }
        } catch (PDOException $e) {
            
        }
    }

    public function getGanreId($name) {
        $name = trim($name);
        if ($name == '') {
            $name = AdminBooksDB_Model::Noname;
        }

        $query = 'SELECT id FROM ganre WHERE name=?';

        try {
            $sth = $this->db->prepare($query);
            $sth->bindParam(1, $name, PDO::PARAM_STR);
            $sth->setFetchMode(PDO::FETCH_ASSOC);
            $sth->execute();

            $rows = $sth->fetch();

            if ($rows) {
                return $rows['id'];
            } else {
                $query = "INSERT INTO ganre(name) values(?)";

                $sth = $this->db->prepare($query);
                $sth->bindParam(1, $name, PDO::PARAM_STR);

                $res = $sth->execute();

                $id = -1;

                if ($res == 1) {
                    $id = $this->db->lastInsertId('id');
                }

                return $id;
            }
        } catch (PDOException $e) {
            
        }
    }

    public function getReaderId($name) {
        $name = trim($name);
        if ($name == '') {
            $name = AdminBooksDB_Model::Noname;
        }

        $query = 'SELECT id FROM reader WHERE name=?';

        try {
            $sth = $this->db->prepare($query);
            $sth->bindParam(1, $name, PDO::PARAM_STR);
            $sth->setFetchMode(PDO::FETCH_ASSOC);
            $sth->execute();

            $rows = $sth->fetch();

            if ($rows) {
                return $rows['id'];
            } else {
                $query = "INSERT INTO reader(name) values(?)";

                $sth = $this->db->prepare($query);
                $sth->bindParam(1, $name, PDO::PARAM_STR);

                $res = $sth->execute();

                $id = -1;

                if ($res == 1) {
                    $id = $this->db->lastInsertId('id');
                }

                return $id;
            }
        } catch (PDOException $e) {
            
        }
    }

    public function getPublishId($name) {
        $name = trim($name);
        if ($name == '') {
            $name = AdminBooksDB_Model::Noname;
        }

        $query = 'SELECT id FROM publish WHERE name=?';

        try {
            $sth = $this->db->prepare($query);
            $sth->bindParam(1, $name, PDO::PARAM_STR);
            $sth->setFetchMode(PDO::FETCH_ASSOC);
            $sth->execute();

            $rows = $sth->fetch();

            if ($rows) {
                return $rows['id'];
            } else {
                $query = "INSERT INTO publish(name) values(?)";

                $sth = $this->db->prepare($query);
                $sth->bindParam(1, $name, PDO::PARAM_STR);

                $res = $sth->execute();

                $id = -1;

                if ($res == 1) {
                    $id = $this->db->lastInsertId('id');
                }

                return $id;
            }
        } catch (PDOException $e) {
            
        }
    }

    public function getCycleBookId($authorId, $name) {
        $name = trim($name);
        if ($name == '') {
            return -1;
        }

        $query = 'SELECT id FROM cycleBook WHERE authorid=? and name=?';

        try {
            $sth = $this->db->prepare($query);
            $sth->bindParam(1, $authorId, PDO::PARAM_INT);
            $sth->bindParam(2, $name, PDO::PARAM_STR);
            $sth->setFetchMode(PDO::FETCH_ASSOC);
            $sth->execute();

            $rows = $sth->fetch();

            if ($rows) {
                return $rows['id'];
            } else {
                $query = "INSERT INTO cycleBook(authorId, name) values(?,?)";

                $sth = $this->db->prepare($query);
                $sth->bindParam(1, $authorId, PDO::PARAM_INT);
                $sth->bindParam(2, $name, PDO::PARAM_STR);

                $res = $sth->execute();

                $id = -1;

                if ($res == 1) {
                    $id = $this->db->lastInsertId('id');
                }

                return $id;
            }
        } catch (PDOException $e) {
            
        }
    }

    public function getQueueFile() {
        $query = "SELECT id, img, status, torrent From books WHERE status  in (0,4) limit 1";
        $sth = $this->db->prepare($query);

        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();
        $row = $sth->fetch();

        if ($row) {
            $query = "SELECT id, source, bookId, fileNum from files WHERE bookid=? and status = 0";

            $sth = $this->db->prepare($query);
            $sth->bindParam(1, $row['id'], PDO::PARAM_INT);
            $sth->setFetchMode(PDO::FETCH_ASSOC);
            $sth->execute();

            return array('bookid' => $row['id'], 'img' => $row['img'], 'status' => $row['status'], 'torrent' => $row['torrent'], 'lst' => $sth->fetchAll());
        }

        return -1;
    }

    public function setBookStatus($id, $status = 1) {
        $query = "UPDATE books set status=? WHERE id=?";

        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $status, PDO::PARAM_INT);
        $sth->bindParam(2, $id, PDO::PARAM_INT);

        return $sth->execute();
    }

    public function setFile($data) {
        $query = "INSERT INTO files(name,source,status,bookid,fileNum) values(?,?,0,?,?)";

        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $data['name'], PDO::PARAM_STR);
        $sth->bindParam(2, $data['source'], PDO::PARAM_STR);
        $sth->bindParam(3, $data['bookid'], PDO::PARAM_INT);
        $sth->bindParam(4, $data['fileNum'], PDO::PARAM_INT);

        $res = $sth->execute();

        if ($res == 1) {
            return $this->db->lastInsertId('id');
        } else {
            return -1;
        }
    }

    public function setFileStatus($id, $status = 2) {
        $query = "UPDATE files set status=? WHERE id=?";

        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $status, PDO::PARAM_INT);
        $sth->bindParam(2, $id, PDO::PARAM_INT);

        return $sth->execute();
    }

    
    public function getBookFilelist($args='')
    {
        $query = "select b.id as bookId, f.id as fileId, b.status as bookStatus, f.status as fileStatus, f.fileNum, f.source as fileName, b.name as bookName from books b join files f on b.id=f.bookId where b.id=?";
        
        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $args['id'], PDO::PARAM_INT);
        
        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();
        
        return $sth->fetchAll();
    }
    
    public function getFilesQueue($args='')
    {
        $query = "select b.id as bookId, f.id as fileId, b.status as bookStatus, f.status as fileStatus, f.fileNum, f.name as fileName, b.name as bookName from books b join files f on b.id=f.bookId where b.status = 0 or b.status = 1 or f.status = 0 or f.status = 1;";
        $sth = $this->db->prepare($query);
        
        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();
        
        return $sth->fetchAll();
    }

    public function getQueueStatus($args='')
    {
        $query = "select f.id as fileId, f.status as fileStatus from books b join files f on b.id=f.bookId where b.status = 0 or b.status = 1 or f.status = 0 or f.status = 1;";
        $sth = $this->db->prepare($query);

        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();

        return $sth->fetchAll();
    }
	
	public function getTorrentQueue($args=''){
		$query = "select * from books where status in (0,3) and torrent <> ''";
        $sth = $this->db->prepare($query);

        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();

        return $sth->fetchAll();
	}
    
    public function setQueueFiles($args='')
    {
        if(count($args['fileids']) > 0)
        {
            $query = "update files set status=0 where id in (" . implode(",", $args['fileids']) . ")";
            $sth = $this->db->prepare($query);
            $sth->execute(); 
        }
        
        if(count($args['bookids']) > 0)
        {
            $query = "update books set status=0 where id in (" . implode(",", $args['bookids']) . ")";
            $sth = $this->db->prepare($query);  
            $sth->execute();
        }
    }
    
    public function getFilesInfo($id)
    {
        $query = "select b.id as bookId, f.id as fileId, b.status as bookStatus, f.status as fileStatus, f.fileNum, f.source as fileName, b.name as bookName, b.source from books b join files f on b.id=f.bookId where b.id=? order by f.numOrder";
        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $id, PDO::PARAM_INT);
        
        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();
        
        return $sth->fetchAll();
    }

    public function updateOrderFiles($args)
    {
	$query = "update files set numOrder=? where bookId=? and Id=?";
	
	$bookId = $args['bookid'];
	$fileIds = explode(",", $args['fileListIds']);
	
	$len = count($fileIds);

	for($i = 1; $i <= $len; $i++)
	{
		$sth = $this->db->prepare($query);
	        $sth->bindParam(1, $i, PDO::PARAM_INT);
        	$sth->bindParam(2, $bookId, PDO::PARAM_INT);
		$sth->bindParam(3, $fileIds[$i - 1], PDO::PARAM_INT);

        	$sth->execute();		
	}
	
    }
    
    public function addCycleBook($args)
    {
        return array();
    }
}
