﻿<?php

error_reporting(E_ALL);
ini_set("display_errors", 1);

function lexa_ci_utf8_like($mask, $value) {
    $mask = str_replace(
            array("%", "_"), array(".*?", "."), preg_quote($mask, "/")
    );
    $mask = "/^$mask$/ui";
    return preg_match($mask, $value);
}

class BooksDB_Model {

    private $db;
    private $isConnrcted;

    public function __construct() {
        try {
            $this->db = new PDO(CONNECTION_STRING, USER, PASSWORD);
            $this->db->sqliteCreateFunction('like', "lexa_ci_utf8_like", 2);
            $this->isConnected = true;
        } catch (PDOException $e) {
            $this->isConnected = false;
        }
    }


    public function isValidUser($user, $pswd)
    {
        $query = "select id from users where login=? and password=?";
    }	

    public function getBooksList($args = false) {

	//author     cycleBook  ganre      publish    users    
	//books      files      lastPlay   reader 

	//id integer primary key autoincrement, name char(150)

        //$query = "select b.id, b.authorId, b.orderId, a.name as author, b.cycleId, c.name as cycle,  b.name, b.img as origImg, 'originImg/' ||  b.id || '.png' as img, b.readerId, r.name as reader, b.ganreId, g.name as ganre, b.time as duration from books b join author a on a.id=b.authorId left join cycleBook c on c.id=b.cycleId join reader r on r.id=b.readerId join ganre g on g.id=b.ganreId";

		//$query = "select b.id, b.authorId, b.orderId, a.name as author, b.cycleId, c.name as cycle,  b.name, b.img as origImg, 'originImg/' ||  b.id || '.png' as img, b.readerId, r.name as reader, b.ganreId, g.name as ganre, b.time as duration, case when lp.bookid is null then 0 else 1 end as opened   from books b join author a on a.id=b.authorId left join cycleBook c on c.id=b.cycleId join reader r on r.id=b.readerId join ganre g on g.id=b.ganreId left join lastPlay lp on lp.bookid=b.id";

	    $query = "select * from bookList";
	    
        /*if ($args) {
            $where = array();

            foreach ($args as $key => $val) {
                $where[] = $key . '=' . $val;
            }

            $query .= ' where ' . implode(' and ', $where);
        }*/

	if(isset($args['orderid']))
	{
		$query .= ' order by id';//b.id';
	}
	else
	{	
        	$query .= ' order by authorId, cycleId, orderId';//b.authorId, b.cycleId, b.orderId';
	}

	//echo '/*'.$query."*/\n";
        
        $sth = $this->db->prepare($query);

        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();

        return $sth->fetchAll();
    }
	
	public function searchBooksList($searchText){
		//$query = "select b.id, b.authorId, b.orderId, a.name as author, b.cycleId, c.name as cycle,  b.name, b.img as origImg, 'originImg/' ||  b.id || '.png' as img, b.readerId, r.name as reader, b.ganreId, g.name as ganre, b.time as duration, case when lp.bookid is null then 0 else 1 end as opened   from books b join author a on a.id=b.authorId left join cycleBook c on c.id=b.cycleId join reader r on r.id=b.readerId join ganre g on g.id=b.ganreId left join lastPlay lp on lp.bookid=b.id";
		//$query .= " where b.name like '%" . $searchText . "%' or a.name like '%" . $searchText . "%' or c.name like '%" . $searchText . "%'";
		//$query .= " group by b.id, b.authorId, b.orderId, a.name, b.cycleId, c.name,  b.name, b.img, b.readerId, r.name, b.ganreId, g.name, b.time, lp.bookid;";
		//echo $query;

		$query = "select * from bookList";
		$query .= "  where name like '%" . $searchText . "%' or author like '%" . $searchText . "%' or cycle like '%" . $searchText . "%'";
		$query .= "  group by id, authorId, orderId, author, cycleId, cycle,  name, origImg, readerId, reader, ganreId, ganre, duration, opened;";

		$sth = $this->db->prepare($query);

        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();

        return $sth->fetchAll();
	}

    public function getLastTime($id, $bookId = 0) {

	 $query = "select id from Users where Email=?";
         $sth = $this->db->prepare($query);
	 $sth->bindParam(1, $id, PDO::PARAM_STR);
	 $sth->setFetchMode(PDO::FETCH_ASSOC);
         $sth->execute();

	 $res = $sth->fetch();

	 if (!$res) {
	 	$query = "insert into Users(Email) values(?)";
                $sth = $this->db->prepare($query);
                $sth->bindParam(1, $id, PDO::PARAM_STR);
                $sth->execute();

		$query = "select id from Users where Email=?";
         	$sth = $this->db->prepare($query);
         	$sth->bindParam(1, $id, PDO::PARAM_INT);
         	$sth->setFetchMode(PDO::FETCH_ASSOC);
         	$sth->execute();

         	$res = $sth->fetch();
	 }


	//echo $id . ' ' . $bookId;    
	if ($bookId == 0) {
            //$query = "select l.bookid, b.name, fileNum, l.time from lastPlay l join users u on l.bookId=u.lastbookId join books b on b.id=l.bookId where u.id=?";
	    $query = "select * from lastPlayTime where userId=?";	
	    $sth = $this->db->prepare($query);
            $sth->bindParam(1, $res['id'], PDO::PARAM_INT);
        } else {
            //$query = "select lp.bookid, b.name, lp.fileNum, lp.time from lastPlay lp join books b on b.id=lp.bookId where lp.userId=? and lp.bookId=?";
	    $query = "select * from lastPlayTime where userId=? and bookId=?";	
	    $sth = $this->db->prepare($query);
            $sth->bindParam(1, $res['id'], PDO::PARAM_INT);
            $sth->bindParam(2, $bookId, PDO::PARAM_INT);
        }

        $sth->setFetchMode(PDO::FETCH_ASSOC);

        $sth->execute();

        $rows = $sth->fetch();



        if (is_array($rows)) {
            return $rows;
        }

        return -1;
    }
 
    public function setPlayTime($info) {
		$res = true;
		//try {
			$query = "select id from Users where Email=?";
         		$sth = $this->db->prepare($query);
         		$sth->bindParam(1, $info['userId'], PDO::PARAM_STR);
         		$sth->setFetchMode(PDO::FETCH_ASSOC);
         		$sth->execute();

			$userid = $sth->fetch();
			$id = $userid['id'];

			//print_r($info);
			//print_r($userid);

			$query = "update users set lastbookId=? where id=?";
			$sth = $this->db->prepare($query);
			$sth->bindParam(1, $info['bookId'], PDO::PARAM_INT);
			$sth->bindParam(2, $id, PDO::PARAM_INT);
			$sth->execute();

			$query = "select * from lastPlay where userId=? and bookId=?";
			$sth = $this->db->prepare($query);
			$sth->bindParam(1, $id, PDO::PARAM_INT);
			$sth->bindParam(2, $info['bookId'], PDO::PARAM_INT);
			$sth->setFetchMode(PDO::FETCH_ASSOC);
			$sth->execute();
			
			$res = $sth->fetch();
 
			if ($res) {
				$query = "update lastPlay set fileNum=?, time=?, lastupdate=datetime('now','localtime') where userId=? and bookId=?";
				$sth = $this->db->prepare($query);

				$sth->bindParam(1, $info['fileNum'], PDO::PARAM_INT);
				$sth->bindParam(2, $info['time'], PDO::PARAM_STR);
				$sth->bindParam(3, $id, PDO::PARAM_INT);
				$sth->bindParam(4, $info['bookId'], PDO::PARAM_INT);
				//$res = 
				$sth->execute();
			} else {
				$query = "insert into lastPlay(bookid,fileNum,time, userId, lastupdate) values(?,?,?,?,datetime('now','localtime'))";
				$sth = $this->db->prepare($query);
				$sth->bindParam(1, $info['bookId'], PDO::PARAM_INT);
				$sth->bindParam(2, $info['fileNum'], PDO::PARAM_INT);
				$sth->bindParam(3, $info['time'], PDO::PARAM_STR);
				$sth->bindParam(4, $id, PDO::PARAM_INT);

				//$res = 
				$sth->execute();
			}
		//} catch (Exception $e) {
            //return $e;
        //}
		
		return $res;
    }

    public function getPlayList($id) {
        $query = "select b.id, f.fileNum, b.img as origImg, 'originImg/' ||  b.id || '.png' as img, f.name from files f join books b on b.id=f.bookid where f.bookid=? order by f.numOrder";
        $sth = $this->db->prepare($query);
        $sth->bindParam(1, $id, PDO::PARAM_INT);

        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();

        return $sth->fetchAll();
    }

    public function getCurrentCycleBooks(){
	$query = "select b1.id, b1.authorId, b1.orderId, a.name as author, b1.cycleId, c.name as cycle,  b1.name, b1.img as origImg, 'originImg/' ||  b1.id || '.png' as img, b1.readerId, r.name as reader, b1.ganreId, g.name as ganre, b1.time as duration, case when b1.id=u.lastbookid then 1 else 0 end as opened from books b join users u on b.id=u.lastbookId join books b1 on b1.cycleid=b.cycleid join author a on a.id=b1.authorId left join cycleBook c on c.id=b1.cycleId join reader r on r.id=b1.readerId join ganre g on g.id=b1.ganreId order by b1.orderid";

	//$query = "select * from currentCycleBooks";    
	$sth = $this->db->prepare($query);

	$sth->setFetchMode(PDO::FETCH_ASSOC);
	$sth->execute();

	return $sth->fetchAll();
    }


    public function getLastTenBooks(){
        $query = "select b.id, b.authorId, b.orderId, a.name as author, b.cycleId, c.name as cycle,  b.name, b.img as origImg, 'originImg/' ||  b.id || '.png' as img, b.readerId, r.name as reader, b.ganreId, g.name as ganre, b.time as duration, case when lp.bookid is null then 0 else 1 end as opened   from books b join author a on a.id=b.authorId left join cycleBook c on c.id=b.cycleId join reader r on r.id=b.readerId join ganre g on g.id=b.ganreId left join lastPlay lp on lp.bookid=b.id order by b.id desc limit 10";

	//$query = "select * from lastTenBooks";    
        $sth = $this->db->prepare($query);

        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();

        return $sth->fetchAll();
    }


    public function getLastTenNotOppenedBooks(){
         $query = "select b.id, b.authorId, b.orderId, a.name as author, b.cycleId, c.name as cycle,  b.name, b.img as origImg, 'originImg/' ||  b.id || '.png' as img, b.readerId, r.name as reader, b.ganreId, g.name as ganre, b.time as duration, case when lp.bookid is null then 0 else 1 end as opened   from books b join author a on a.id=b.authorId left join cycleBook c on c.id=b.cycleId join reader r on r.id=b.readerId join ganre g on g.id=b.ganreId left join lastPlay lp on lp.bookid=b.id where lp.bookid is null order by b.id desc limit 10";

	//$query = "select * from lastTenNotOpenedBooks";    
	$sth = $this->db->prepare($query);

        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();

        return $sth->fetchAll();
    }


    public function getlastTenOpened(){
	 $query = "select b.id, b.authorId, b.orderId, a.name as author, b.cycleId, c.name as cycle,  b.name, b.img as origImg, 'originImg/' ||  b.id || '.png' as img, b.readerId, r.name as reader, b.ganreId, g.name as ganre, b.time as duration, 0 as opened from lastplay l join books b on l.bookid=b.id join author a on a.id=b.authorId left join cycleBook c on c.id=b.cycleId join reader r on r.id=b.readerId join ganre g on g.id=b.ganreId where l.lastupdate is not null order by l.lastupdate desc limit 10";

	//$query = "select * from lastTenOpenedBooks";
        $sth = $this->db->prepare($query);

        $sth->setFetchMode(PDO::FETCH_ASSOC);
        $sth->execute();

        return $sth->fetchAll();

    }	
}
