<?php

define('OK', 'OK');
define('WARNING', 'WARNING');
define('ERROR', 'ERROR');
define('AUTH_ERROR', 'AUTH_ERROR');

/**
 * 
 * Enter description here ...
 * @author ychokov
 *
 */
class Helper
{
	/**
	 * 
	 * Enter description here ...
	 * @param unknown_type $controllerName
	 * @throws AppException
	 */
	public static function loadController($controllerName)
	{
            $file = 'Controller/' . $controllerName . '_Controller.php';
            
            if (!file_exists($file))
            {
                throw new AppException("Not found file $file of Controller ", 3);
            }
            
            require_once($file);
            
            $class_name = $controllerName . '_Controller';
            
            if(!class_exists($class_name))
            {
                    throw new AppException("Not found Class $class_name of Controller $controllerName", 3);
            }
            
            $controller = new $class_name();
            
            return $controller;
	}

        /**
         *
         * @param type $file
         * @param type $modele_name
         * @param type $args
         * @return modele_name 
         */
        public static function loadModule($file, $modele_name, $args=false)
        {
            if (!file_exists($file))
            {
                throw new AppException("Not found file $file of Module", 3);
            }
            
            include_once($file);
            
            if(!class_exists($modele_name))
            {
                throw new AppException("Not found Class $class_name of Module $modele_name", 3);
            }

            if(!$args)
            {
                $module = new $modele_name();
            }
            else
            {
                $module = new $modele_name($args);
            }
            
            return $module;
        }
        
	/**
	 * 
	 * Enter description here ...
	 * @param unknown_type $modelName
	 * @throws AppException
	 */
	public static function loadModel($modelName, $args=false)
	{
            $file = 'Model/' . $modelName . '_Model.php';
            
            if (!file_exists($file))
            {
                throw new AppException("Not found file $modelName of Model", 3);
            }
            
            include_once($file);
            
            $class_name = $modelName . '_Model';
            
            if(!class_exists($class_name))
            {
                throw new AppException("Not found Class $class_name of Model $modelName", 3);
            }

            if(!$args)
            {
                $model = new $class_name();
            }
            else
            {
                $model = new $class_name($args);
            }
            
            return $model;
	}
	
	/**
	 * 
	 * Enter description here ...
	 * @param unknown_type $viewName
	 * @param unknown_type $values
	 * @throws AppException
	 */
	public static function loadView($viewName, $values='')
	{
            global $data;
            $data = $values;
            $file = 'View/' . $viewName . '_View.php';
            
            if (!file_exists($file))
            {
                throw new AppException("Not found file $file of View", 3);
            }
            
            include_once($file);
	}

	/**
	 *
	 *
	 */
	public static function json($data, $status=OK)
	{
		header('Content-Type: application/json; charset=utf-8');
		return json_encode(array('status' => $status, 'data' => $data)/*, JSON_UNESCAPED_UNICODE*/);
	}
}
?>
