<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class Security
{
    private $policy;
    private static $isecurity;

    /**
     *
     * @param type $policy 
     */
    public function __construct($policy)
    {
        $this->policy = $policy;
        
        if('' == SECURITY_MODULE)
        {
            $default_module_name = 'DefaultSecurityModule';
            $default_module_file = ENGINE_PATH . $default_module_name . ".php" ;
            $module = Helper::loadModule($default_module_file, $default_module_name);
        }
        else 
        {
            $file_of_module = "System/" . SECURITY_MODULE . ".php";
          
            $module = Helper::loadModule($file_of_module , SECURITY_MODULE);    
        }
        
        Security::$isecurity = $module;
    }
    
    /**
     *
     * @param ISecurity $security 
     */
    public function setSecurityModul(ISecurity $security)
    {
        Security::$isecurity = $security;
    }
    
    
    /**
     *
     * @param type $controller
     * @param type $method 
     */
    public function isAllowsRequest(URL $url)
    {
        $name = $url->getControllerName();
        
        if(!isset($this->policy[$name]))
        {
            throw new AppException("Not found policy for controller $name", 0);
        }
        
        $config = $this->policy[$name];
        
        if(isset($config['without_auth']))
        {
            $without_auth = in_array($url->getMethodName(), $config['without_auth']);
        }
        else
        {
            $without_auth = false;
        }
        
        if(!$without_auth)
        {
            if($this->isAuth())
            {
                $method = $url->getMethodName();
                
                if(!in_array($method, $config['with_auth']))
                {
                    throw new AppException("Not found for policy for method $method of Controller $name", 1);
                }
            }
            else
            {
                throw new AppException("Authorization error", 2);
            }
        }
        
        return true;
    }
    
    /**
     *
     * @return type 
     */
    public static function isAuth()
    {
        return Security::$isecurity->isAuthorization();
    }	
    
    /**
     * 
     * Enter description here ...
     */
    public static function login()
    {
    	Security::$isecurity->loginUser();
    }
    
    /**
     * 
     * Enter description here ...
     */
    public static function logout()
    {
    	Security::$isecurity->logoutUser();
    }
}
?>