<?php
/**
 * 
 * Enter description here ...
 * @author ychokov
 *
 */
class URL 
{
    private $controller;
    private $controllerName;
    private $method;
    private $args;
    
    /**
     * 
     */
    public function __construct($redirect=false)
    {
        $this->controller = false;
        $this->method = false;
        $this->args = false;
        
	$str = $_SERVER['REQUEST_URI'];

	if($redirect)
	{
		foreach($redirect as $val)
		{
			preg_match($val['path'], $str, $matches);

			if($matches)
			{
				$str = str_replace('$1', $matches[1], $val['redirectTo']);
				break;
			}

		}
	}	

        $str = preg_replace('/\/index.php/', '', $str);
        $str = preg_replace('/\/$/','',$str);
        $pos = strpos($str,'?');
        
        if(false !== $pos)
        {
            $str = substr($str, 0, $pos);
        }
        
        $urlitm = explode('/', $str);
        $count = count($urlitm);
        
        if($count > START_URL_ITEM && !empty($urlitm[START_URL_ITEM]))
        {
            $this->controllerName = $urlitm[START_URL_ITEM];
        }
        else
        {
            $this->controllerName = DEFAULT_CONTROLLER;
        }
        
        $this->controller = Helper::loadController($this->controllerName);
        
        if($count > START_URL_ITEM + 1 && !empty($urlitm[START_URL_ITEM + 1]))
        {
            $this->method = $urlitm[START_URL_ITEM + 1];
        }
        else
        {
            $this->method = 'index';
        }
        
        if(!method_exists($this->controller, $this->method))
        {
            throw new AppException("Can not found method " . $this->method 
                                . " of Controller " . $this->controllerName, 5);
        }
        
        if($count + count($_POST) + count($_GET) > START_URL_ITEM + 2)
        {
            $this->args = array_merge(array_slice($urlitm, START_URL_ITEM + 2), $_POST, $_GET);
        }
    }
    
    /**
     *
     * @return type 
     */
    public function isExistsArguments()
    {
    	return (false !== $this->args);
    }
    
    /**
     *
     * @return type 
     */
    public function getControllerName()
    {
    	return $this->controllerName;
    }
    
    /**
     *
     * @return type 
     */
    public function getController()
    {
        return $this->controller;
    }
    
    /**
     *
     * @return type 
     */
    public function getMethodName()
    {
        return $this->method;
    }
    
    /**
     *
     * @return type 
     */
    public function getArgumnets()
    {
        return $this->args;
    }
}

?>
