<?php
session_start();

// Подключаем настройки Googel API
include "google_verification.php";

// Подключаем библиотеку the Google API client library for PHP(https://code.google.com/p/google-api-php-client/downloads/list)
require_once 'src/Google_Client.php';
require_once 'src/contrib/Google_Oauth2Service.php';


$googleClient = new Google_Client();
$googleClient->setApplicationName('Your APP Name');
$googleClient->setClientId($clientID);
$googleClient->setClientSecret($clientSecret);
$googleClient->setRedirectUri($redirectURL);
$googleClient->setDeveloperKey($apiKey);

$google_oauthV2 = new Google_Oauth2Service($googleClient);

if (isset($_REQUEST['logout'])) 
{
  unset($_SESSION['token']);
  $googleClient->revokeToken();
  header('Location: ' . $redirectURL);
}


// Действие если отправлен код
if (isset($_GET['code'])) 
{ 
	$googleClient->authenticate($_GET['code']);
	$_SESSION['token'] = $googleClient->getAccessToken();
	header('Location: ' . $redirectURL);
	return;
}

// Действие если отправлен токен
if (isset($_SESSION['token'])) 
{ 
		$googleClient->setAccessToken($_SESSION['token']);
}


if ($googleClient->getAccessToken()) 
{
	  // Извлекаем данные пользователя и сохраняем их в виде массива
	  $data 				= $google_oauthV2->userinfo->get();
	  
	  $user_id 				= $data['id'];
	 
	  $user_name 			= $data['name'];
	 
	  $email 				= $data['email'];
	 
	  $profile_url 			= $data['link'];
	 
	  $profile_image_url 	= $data['picture'];

	  $_SESSION['token'] 	= $googleClient->getAccessToken();
}
else 
{
	//Генерируем ссылку авторизации
	$login_url = $googleClient->createAuthUrl();

}



echo '<html><head>';
echo '<title>Авторизация с помощью Google</title>';
echo '</head>';
echo '<body>';
if(isset($login_url)) //Пользователь не авторизован, показываем кнопку авторизации
{
	echo '<a class="login" href="'.$login_url.'"><img src="index.jpg" /></a>';

} 
else // Авторизация успешна, выводим информацию о пользователе
{

	foreach($data as $key=>$value){
		echo "$key is $value<br /><br />";
	}
	echo '<br /><a class="logout" href="?logout=1">Logout</a>'; 
}

echo '</body></html>';
?>

