#!/usr/bin/php
<?php
require_once 'config.php';
require_once ENGINE_PATH . '../Model/BooksDb_Model.php';
require_once ENGINE_PATH . '../Helpers/AppHelper.php';

$db = new BooksDB_Model();

$args = array('status' => 2);
$data = $db->getBooksList($args);

$path = sprintf("%s/origin/", IMAGEFILE_PATH);
$pathSmall = sprintf("%s/small/", IMAGEFILE_PATH);

foreach($data as $val)
{
	$cont = AppHelper::loaData($val['img']);

	if(strpos($cont, "<html>") === false)
	{
		$file = $path . $val['id'] . '.png';

		if(!file_exists($file))
		{	
			echo 'try download file: ' . $val['img'] . "\n"; 
			file_put_contents($file, $cont);
			echo 'downloaded to: ' . $file . "\n";

			$fileSmall = $pathSmall . $val['id'] . '.png';
			echo $fileSmall;

			$rimg = resize_image($file, 120, 120);

			imagejpeg($rimg, $fileSmall, 70);
		}
	}
}

function resize_image($file, $w, $h, $crop=FALSE) {
    list($width, $height) = getimagesize($file);
    $r = $width / $height;
    if ($crop) {
        if ($width > $height) {
            $width = ceil($width-($width*abs($r-$w/$h)));
        } else {
            $height = ceil($height-($height*abs($r-$w/$h)));
        }
        $newwidth = $w;
        $newheight = $h;
    } else {
        if ($w/$h > $r) {
            $newwidth = $h*$r;
            $newheight = $h;
        } else {
            $newheight = $w/$r;
            $newwidth = $w;
        }
    }
    $src = imagecreatefromjpeg($file);
    $dst = imagecreatetruecolor($newwidth, $newheight);
    imagecopyresampled($dst, $src, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);

    return $dst;
}

