<?php
/**
 * @author ychokov
 */
session_start();


require_once 'config.php';
require_once ENGINE_PATH . 'ISecurity.php';
require_once ENGINE_PATH . 'AppException.class.php';
require_once ENGINE_PATH . 'Helper.class.php';
require_once ENGINE_PATH . 'URL.class.php';
require_once ENGINE_PATH . 'Security.class.php';

try
{
	$url = new URL($redirect);
	$security_object = new Security($request_policy);
	$security = $security_object->isAllowsRequest($url);
	$controller = $url->getController();
	$method = $url->getMethodName();
	
	if($url->isExistsArguments())
	{
		echo $controller->$method($url->getArgumnets());
	}
	else
	{
		echo $controller->$method();
	}
}
catch(AppException $e)
{
	if(2 == $e->getCode())
	{
		echo Helper::json($e->getMessage(), AUTH_ERROR);
	}
	else
	{
		echo Helper::json($e->getMessage(), ERROR);
	}
}
?>
