var torrent = new TransmissionRemote;
var global;
angular.module('AdminApp',[])
.directive('toggle',function(){
	return {
		restrict:'A',
		link:function(scope, element, attrs){
			element.parent().bind('click', function(){
				if(element.hasClass('opened')){
					element.removeClass('opened');
				}else{
					element.addClass('opened');
				}
			});
		}
	};
})
.directive('directory',function(){
	
	function buildNodes(path, node, func, func1){
		func(path, function(data){
			
			node.addClass('loaded');
			var ul = angular.element('<ul>');
			ul.addClass('opened');
			node.append(ul);
			angular.forEach(data, function(item){
				var li = angular.element('<li>');
				li.attr({path:path + '/' + item.name});
				ul.append(li);
				li.html('<span><img src="images/' +item.type+ '.png"/>' + item.name + '</span>');
				
				if(item.type == 'folder'){
					li.bind('click', function(){
						func1(li.attr('path'));
						if(!li.hasClass('loaded'))
						{
							buildNodes(path + '/' + item.name, li, func, func1);
						}else{
							var ul1 = li.find('ul');
							if(ul1.hasClass('opened')){
								ul1.removeClass('opened')
							}else{
								ul1.addClass('opened');
							}
						}
						
						return false;
					});
				}else{
					li.bind('click', function(){func1(li.attr('path')); return false;});
				}
			});
		});
	}
	
	return {
		restrict:'A',
		link:function(scope, element, attrs){
			buildNodes('', element, scope[attrs.directory], scope[attrs.selected]);
		}
	};
})
.controller('AdminController',['$scope','$http', function($scope, $http){
	global = $scope;
	$scope.searchUrl = '';
	$scope.bookData = null;
	$scope.torrentData = {}; 
	$scope.preparedTorrent = [];
	RPC._Root = "/books/transmission/rpc";	
	$scope.searchBook = function(){
		$http.get('Admin/addBook',{params:{url:$scope.searchUrl}})
		.then(function(data){
			console.log(data);
			$scope.bookData = data.data.data;
			
			console.log($scope.bookData);
		}, function(){
			console.log('error')
		});
		
		$scope.loadTorrentInfo();
	};
	
	$scope.addTorrent = function(){
		console.log('add', $scope.bookData.torrent);
		$http.get('Admin/applyBook', null,).then(function(data){
			//if(data.data){
				torrent.addTorrentByUrl($scope.bookData.torrent, {paused:false});
				//var id = $scope.bookData.torrent.replace('magnet:?xt=urn:btih:','');
			
				$scope.loadTorrentInfo();
			//}
		});
	};
	
	$scope.getPreparedTorrent = function(){
		$http.get('Admin/getTorrentQueue', null).then(function(data){
			console.log(data.data.data, $scope.torrentData.arguments.torrents);
			$scope.preparedTorrent = [];
			$scope.loadTorrentInfo(function(){

				console.log($scope.torrentData);
				
				angular.forEach($scope.torrentData.arguments.torrents, function(titem){
						console.log('titem', titem);	
					angular.forEach(data.data.data, function(ditem){
						console.log(titem,ditem);
						
						if(ditem.torrent.indexOf(titem.hashString) > 0)
						{
							//console.log('matched', ditem);
							$scope.preparedTorrent.push(
								{bookid: ditem.id, name:titem.name, directory:titem.downloadDir, files: titem.files}
							);
						}
					});
				});
				
				console.log($scope.preparedTorrent);
				$scope.$apply();
			});
		});
	};
	
	$scope.applyBookFiles = function(id){
		
		var req = {
			method: 'POST',
			url: 'Admin/applyBookFiles',
			data: 'data=' + JSON.stringify($scope.preparedTorrent[id]),
			headers: {'Content-Type': 'application/x-www-form-urlencoded'}
		}
		
		$http(req).then(function(data){
			console.log(data);
			$scope.getPreparedTorrent();
		});
	}
	
	$scope.readDir = function(path, func){
		$http.get('Admin/getPath',{params:{path:path}})
		.then(function(data){
			if(func){	
				func(data.data.data);
			}
		});
	};
	
	$scope.path = '';
	
	$scope.selectedDir = function(path){
		console.log(path);
		$scope.path = path;
		$scope.$apply();
	};
	
	$scope.getSelectedPath = function(){
		return $scope.path;
	};
	
	$scope.loadTorrentInfo = function(func){
		//torrent.getInitialDataFor(null, function(data){
		//	$scope.torrentData = data;
		//	console.log(data);
		//	
		//	if(func){
		//		func();
		//	}
		//});
		torrent.sendRequest({method: 'torrent-get',arguments: {'fields': ["id","files","hashString"]}},function(data){
			$scope.torrentData = data;
			if(func){
				func();
			}
		});
	};
	
	//$scope.readDir('');
	//$scope.loadTorrentInfo();
}]);
