var myPlaylist;
var loadLastBook = function(){};
var loadPlayList = function(){};
var openBook = false;

$(document).ready(function () {
	
	var currentItem;
	var bookList = $('#bookList .modal-body');
	var bookListItem = [
		'<div class="book-item row book-info">',
			'<div class="col-sm-3">',
				'<img class="book-img" />',
			'</div>',
			'<div class="col-sm-9">',
				'<div class="row">',
					'<div class="col-sm-12 book-name"></div>',
				'</div>',
				'<div class="row">',
					'<div class="col-sm-6 "><label>Автор:</label><span class="book-author"></span></div>',
					'<div class="col-sm-6"><label>Жанр:</label><span class="book-ganre"></span></div>',
				'</div>',
				'<div class="row">',
					'<div class="col-sm-6"><label>Цыкл:</label><span class="book-cycle"></span></div>',
					'<div class="col-sm-6"><label>Книга:</label><span class="bookcycleid"></span></div>',
				'</div>',
				'<div class="row">',
					'<div class="col-sm-6"><label>Время:</label><span class="book-duration"></span></div>',
					'<div class="col-sm-6"><label>Читает:</label><span class="book-reader"></span></div>',
				'</div>',
			'</div>',
		'</div>'
	].join('');
	
	var books = openBookList($('#books'), 'Main/getBooksList');
	openBookList($('#all_books'),'Main/getBooksList');
	openBookList($('#open_last_ten'), 'Main/getLastTenBooks');
	openBookList($('#open_current_cycle'), 'Main/getCurrentCycleBooks');
	openBookList($('#last_ten_oppened'), 'Main/getlastTenOpened');
	openBookList($('#not_opened_last_ten'), 'Main/getLastTenNotOppenedBooks');
	searchBooks($('#search_book'), 'Main/serarchBooks');

	$(window).on('resize', function(){
  		var h_navbar = $('.navbar').height();
		$('.jp-video').css({'margin-top': h_navbar + 'px'});	
	});

	myPlaylist = new jPlayerPlaylist({
        jPlayer: "#jquery_jplayer_N",
        cssSelectorAncestor: "#jp_container_N"
    }, [], {
        playlistOptions: {
            enableRemoveControls: false
        },
        swfPath: "../../dist/jplayer",
        supplied: "webmv, ogv, m4v, oga, mp3",
        useStateClassSkin: true,
        autoBlur: false,
        smoothPlayBar: true,
        keyEnabled: true,
        audioFullScreen: true
    });

	function searchBooks (obj, url)
	{
		var modal_box = $("#bookList");
		obj
			.click(function(){
				bookList.html('');
				var last_url = modal_box.attr('url');
				
				bookList.append(
					$('<div style="margin-bottom:20px">')
						.append('<input type="text" placeholder="Искать книгу" id="search-text" style="margin-right:10px; width:88%">')
						.append('<input type="button" value="Поиск" id="search_btn">')
				);
				
				var searchContentBox = $('<div id="search-content-box">');
				bookList.append(searchContentBox);
		
		
				$('#search_btn').click(function(){
					var search_url = url + '/' + $('#search-text').val();
					loadBooksInfo(search_url, searchContentBox, function(){
						//setTimeout(function(){$('#bookList').scrollTop($('#bookList .selected').position().top);},100);
					});
				});
				
				$("#search-text").on('keyup', function (e) {
					if (e.key === 'Enter' || e.keyCode === 13) {
						var search_url = url + '/' + $('#search-text').val();
						loadBooksInfo(search_url, searchContentBox, function(){
							//setTimeout(function(){$('#bookList').scrollTop($('#bookList .selected').position().top);},100);
						});
					}
				});
				
				modal_box.modal();
			});
	}

    function openBookList(obj, url)
    {
		var modal_box = $("#bookList");
		var last_url = modal_box.attr('url');

	   obj
		.click(function(){
				//if(bookList.find('div').length == 0)
				if(last_url != url)
				{
						loadBooksInfo(url, bookList, function(){
								modal_box.modal();
								setTimeout(function(){$('#bookList').scrollTop($('#bookList .selected').position().top);},100);
				modal_box.attr({'url':url});
						});
				}
				else
				{
						modal_box.modal();
						setTimeout(function(){$('#bookList').scrollTop($('#bookList .selected').position().top);},100);
				}
		});

		return obj;
    }	
	
			
    function setLastTime(bookId, fileNum, time)
    {
        var email = getCookie('userid');
	$('.navbar-brand').attr({"href":baseUrl + bookId + 'a' + fileNum + 'a' + time});

	$.ajax({
            url: 'Main/setPlayTime',
            data: {time: time, bookId: bookId, fileNum: fileNum, email:email},
            dataType: 'json',
            success: function (data) {

            }
        });
    }

    function loadBooksInfo(url,obj,func)
    {
		obj.html('');
		$('#loading').show();
		
        $.ajax({
            url: url,
            dataType: 'json',
            success: function (data) {
				var val = data.data;
				for (var i in val)
				{
					var tmpl = $(bookListItem);	
					var img = tmpl.find('img');
					var name = tmpl.find('.book-name');
					var author = tmpl.find('.book-author');
					var ganre = tmpl.find('.book-ganre');
					var duration = tmpl.find('.book-duration');
					var cycle = tmpl.find('.book-cycle');
					var bookcycleid = tmpl.find('.bookcycleid');
					var reader = tmpl.find('.book-reader');
							
					var bookInfo = tmpl.find('.book-info');
							
					if(bookid == val[i].id)
					{
						tmpl.addClass('selected');
						currentItem = tmpl;
					}
					else
					{
						if(parseInt(val[i].opened) == 0)
						{
							tmpl.addClass('not-opened');
						}
					}
							
					img.attr({
						src:'./originImg/' + val[i].id + '.png',
						onerror:"this.src='./images/not-found.jpg'"
					});
							
					name.html(val[i].name);
					author.html(' ' + val[i].author);
					ganre.html(' ' + val[i].ganre);
					duration.html(' ' + val[i].duration);
					if(val[i].cycle)
					{
						cycle.html(' ' + val[i].cycle);
						bookcycleid.html(' ' + val[i].orderId);
					}
					else
					{
						cycle.parent().parent().html('');
						//cycle.parent().html('');
					}
					reader.html(' ' + val[i].reader);
							
					tmpl.attr({
						'data-val':val[i].id,
						'data-name':val[i].name,
						'data-dismiss':'modal'
						});
							
					tmpl.click(function(){
						bookid = $(this).data('val')
						loadPlayList(bookid);
						books.html($(this).data('name'));
							
						currentItem.removeClass('selected');
						currentItem = $(this);
						currentItem.addClass('selected');
					})
							
					obj.append(tmpl);
				}

				if (func != undefined)
				{
					func();
				}
						
				$('#loading').hide();
			}
        });
    }

    loadPlayList = function (args, func)
    {
	console.log('args',args);

	if (typeof args === 'number') {
  		args += '';
	}

	var arr_args = args.split('a');
	var id = arr_args[0];


	$('#loading').show();
	var email = getCookie('userid');
		
        $.ajax({
            url: 'Main/getPlayList',
            data: {id: id, email:email},
            dataType: 'json',
            success: function (data) {


	    var val = data.data;		
		console.log(val);
            myPlaylist.setPlaylist(val.list);	

            if (val.lastPlay != false && arr_args.length == 1)
            {
	            var tag = $('.jp-jplayer audio')[0];
                    var time = parseFloat(val.lastPlay.time);

                    lastTime = currentTime = time;

                    var setuped = false;

                    if (tag != null)
                    {
                        tag.addEventListener("canplay", function () {
                        if (!setuped)
                        {
         	               setTimeout(function () {
                                    time && (tag.currentTime = time, time = null);
                                }, 1000);
                                setuped = true;
                            }
                        });
                    }

                    myPlaylist.select(parseInt(val.lastPlay.filenum));
             }
	     else if(arr_args.length == 3)
	     {
		    var tag = $('.jp-jplayer audio')[0];
                    var time = parseFloat(arr_args[2]);

                    lastTime = currentTime = time;

                    var setuped = false;

                    if (tag != null)
                    {
                        tag.addEventListener("canplay", function () {
                        if (!setuped)
                        {
                               setTimeout(function () {
                                    time && (tag.currentTime = time, time = null);
                               }, 1000);
                                setuped = true;
                            }
                        });

			$('.jp-play').trigger('click');
			    
                    }

                    myPlaylist.select(parseInt(arr_args[1]));
	     }

                if (func != undefined)
                {
                    func();
                }
				
		$('#loading').hide();
            }
        });
    }


   loadLastBook = function(email, func){ 
	$.ajax({
        	url: 'Main/getLastTime',
		data: { email: email },
        	dataType: 'json',
        	success: function (data) {

            		if (data.data == false || data.data == -1)
            		{
                		//loadBooksInfo();
				if(func){
					func(false);
				}

            		} else {
                		//loadBooksInfo(function () {
                    		//books.val(data.data.bookid);
				books.html(data.data.name);
                		loadPlayList(data.data.bookid)
				bookid = data.data.bookid;

				if(func){
					func(true);
				}
                		//})
            		}

		 	var h_navbar = $('.navbar').height();
        		$('.jp-video').css({'margin-top': h_navbar + 'px'});

        	}
    	});
   };

	var lastTime, currentTime;
	var bookid, scrollTop;

	setInterval(function () {
        
        	currentTime = $('#jquery_jplayer_N').data("jPlayer").status.currentTime;

        	if (lastTime != currentTime && currentTime > 0 && bookid > 0)
        	{
            		setLastTime(bookid, myPlaylist.current, currentTime);
        	}

        	lastTime = currentTime;
	}, 30000);


	$('.navbar-brand').unbind().click(function(){ 
		console.log('click');
		
		return false;
	})
});

$('body').keydown(function(e){
	console.log(e);
        if(e.which == 13){//Enter key pressed
            if($('#jquery_jplayer_N').data().jPlayer.status.paused)
		{
			myPlaylist.play();
		}else{
			myPlaylist.pause();
		}
        }
});
