function setCookie(cname, cvalue, exdays) {
  const d = new Date();
  d.setTime(d.getTime() + (exdays*24*60*60*1000));
  let expires = "expires="+ d.toUTCString();
  document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}


function getCookie(cname) {
  let name = cname + "=";
  let decodedCookie = decodeURIComponent(document.cookie);
  let ca = decodedCookie.split(';');
  for(let i = 0; i <ca.length; i++) {
    let c = ca[i];
    while (c.charAt(0) == ' ') {
      c = c.substring(1);
    }
    if (c.indexOf(name) == 0) {
      return c.substring(name.length, c.length);
    }
  }
  return "";
}


function renderButton() {
	$('#loading').hide();
	
	var userid = getCookie('userid');

	if(openBook)
	{
		loadPlayList(openBook);
	}
	else
	{

		if(userid)
		{
			loadLastBook(userid);
		}else{
    			gapi.signin2.render('gSignIn', {
        			'scope': 'profile email',
        			'width': 240,
        			'height': 50,
        			'longtitle': true,
        			'theme': 'dark',
        			'onsuccess': onSuccess,
        			'onfailure': onFailure
    			});
		}
	}
}


function onSuccess(googleUser) {
    
	gapi.client.load('oauth2', 'v2', function () {
        var request = gapi.client.oauth2.userinfo.get({
            'userId': 'me'
        });
        request.execute(function (resp) {
            	
		setCookie('userid', resp.email, 365);
		loadLastBook(resp.email);
		document.getElementById("gSignIn").style.display = "none";
        });
    });
}

function onFailure(error) {
    alert(error);
}

function signOut() {
    var auth2 = gapi.auth2.getAuthInstance();
    auth2.signOut().then(function () {
        document.getElementById("gSignIn").style.display = "block";
    });
    
    auth2.disconnect();
}

function login(email){

	 setCookie('userid', email, 365);
         
	 loadLastBook(email, function(res){
		if(!res){
			 setCookie('userid', '', -10);
		}
	 });
         document.getElementById("gSignIn").style.display = "none";
}
