<?php

require_once 'baseParser.php';
require_once 'bookParserInterface.php';


class AbookFm extends BaseParser implements iParserInterface
{
	CONST URL = "https://abook.fm%s";
	CONST PLAYLIST_URL = "https://abook.fm/rest/book/%d/chapters";
	
	public function __construct($url)
	{
		parent::__construct($url);
	}

	public function getData()
	{
		$result = array(
			'publish' => '',
			'cycle' => '',
			'numCycle' => '',
			'time' => '',
			'year' => '',
			'reader' => ''
		);
	 
		$content = $this->loadData();
		$result['source'] = $this->url;
		$result['name'] = trim(utf8_decode($this->xpath->query('/html/body/div[2]/div[1]/div/div[1]/div[1]/div/div[1]/h1')->item(0)->textContent));
		$result['img'] = sprintf(AbookFm::URL, trim($this->xpath->query('/html/body/div[2]/div[1]/div/div[1]/div[1]/div/div[3]/div[1]/img')->item(0)->getAttribute('src')));
		$result['description'] = trim(utf8_decode($this->xpath->query('/html/body/div[2]/div[1]/div/div[1]/div[1]/div/div[3]/div[2]')->item(0)->textContent));
		$result['time'] = trim($this->xpath->query("/html/body/div[2]/div[1]/div/div[1]/div[1]/div/div[1]/span")->item(0)->textContent);
		
		
		$result['ganre'] = trim(utf8_decode($this->xpath->query('/html/body/div[2]/div[1]/div/div[1]/div[1]/div/div[2]/a[1]')->item(0)->textContent));
		$result['reader'] = trim(utf8_decode($this->xpath->query('/html/body/div[2]/div[1]/div/div[1]/div[1]/div/div[2]/a[2]')->item(0)->textContent));
		$result['author'] = trim(utf8_decode($this->xpath->query('/html/body/div[2]/div[1]/div/div[1]/div[1]/div/div[2]/a[3]')->item(0)->textContent));
		
		$options = $this->xpath->query('/html/body/div[2]/div[1]/div[1]/div[1]/div[3]/div/div[2]'); 
		
		
		$req = "/AbookJPlayer\(([0-9]+)/";
		preg_match($req, $content, $matches);
		
		$result['playList'] = sprintf(AbookFm::PLAYLIST_URL, $matches[1]);
		$filesData = AppHelper::loaData($result['playList']);
		
		$filesObj = json_decode($filesData);

		$arr = array();
        foreach($filesObj as $obj)
        {
            $arr[] = array('title' => $obj->name, 'file' => sprintf(AbookFm::URL, $obj->files[0]->path));
        }
        
        $result['fileLst'] = $arr;
		
		return $result;
	}
}

