<?php

require_once 'baseParser.php';
require_once 'bookParserInterface.php';

class AsbookNet extends BaseParser implements iParserInterface {

    public function __construct($url) {
        parent::__construct($url);
    }

    public function getData() {
        $result = array(
            'publish' => '',
            'cycle' => '',
            'numCycle' => '',
        );

        $content = $this->loadData();

        $result['source'] = $this->url;
        $result['name'] = trim($this->xpath->query('/html/body/div[3]/div[2]/div/div[1]/div[2]/div/h1')->item(0)->textContent);
        $result['img'] = trim($this->xpath->query('/html/body/div[3]/div[2]/div/div[1]/div[2]/div/div[5]/div/div/div[1]/div/img')->item(0)->getAttribute('src'));
        @$result['description'] = trim($this->xpath->query('/html/body/div[3]/div[2]/div/div[1]/div[2]/div/div[5]/div/div/div[2]/div/dl/dt[1]')->item(0)->textContent);
        
        if($result['description'] == '')
        {
            $result['description'] = trim($this->xpath->query('/html/body/div[3]/div[2]/div/div[1]/div[2]/div/div[5]/div/div/div[2]/div/p')->item(0)->textContent);
        }
        
        $result['author'] = trim($this->xpath->query('/html/body/div[3]/div[2]/div/div[1]/div[2]/div/div[5]/div/div/div[3]/div[1]/div/div[1]/div[2]/a')->item(0)->textContent);
        $result['reader'] = trim($this->xpath->query('/html/body/div[3]/div[2]/div/div[1]/div[2]/div/div[5]/div/div/div[3]/div[1]/div/div[2]/div[2]/a')->item(0)->textContent);
        $result['year'] = trim($this->xpath->query('/html/body/div[3]/div[2]/div/div[1]/div[2]/div/div[5]/div/div/div[3]/div[1]/div/div[4]/div[2]/a')->item(0)->textContent);
        $result['time'] = trim($this->xpath->query('/html/body/div[3]/div[2]/div/div[1]/div[2]/div/div[5]/div/div/div[3]/div[1]/div/div[5]/div[2]')->item(0)->textContent);
        $result['ganre'] = trim($this->xpath->query('/html/body/div[3]/div[2]/div/div[1]/div[2]/div/div[1]/a[2]')->item(0)->textContent);


        $cmd = ENGINE_PATH . '../parser/parser.js ' . $this->url;
        $read = '';
        $handle = popen($cmd, 'r');
        while (!feof($handle)) {
            $read .= fread($handle, 2048);
        }
        pclose($handle);

        $arr = json_decode($read);


        $result['playList'] = json_encode($arr->playlistUrl);

        $file = array();
        foreach ($arr->res->playlist as $obj) {
            $file[] = array('title' => $obj->comment, 'file' => $obj->file);
        }

        $result['fileLst'] = $file;

        return $result;
    }

}
