<?php

error_reporting(E_ALL);
ini_set("display_errors", 1);

require_once 'baseParser.php';
require_once 'bookParserInterface.php';

class AudioBooOrg extends BaseParser implements iParserInterface {

	CONST URL = "http://audioboo.org%s";
	CONST PLAY_URL = "https://archive.org%s";

	public function __construct($url) {
        	parent::__construct($url);
	}


	private function getDetailsBook($data) {
        	$keys = array(
            		'year' => array('Год выпуска','Год выпуска аудиокниги'),
	            	'afname' => array('Имя автора'),
        	    	'alname' => array('Фамилия автора'),
            		'author' => array('Автор'),
	            	'ganre' => array('Жанр'),
        	    	'publish' => array('Прочитано по изданию','Издательство'),
            		'time' => array('Время звучания','Продолжительность'),
	            	'reader' => array('Исполнитель'),
			'cycle' => array('Цикл/серия'),
			'numCycle' => array('Номер в серии/цикле','Номер книги'),
		    	'description' => array('Описание')
        	);

	        $result = array(
			'year' => '',
			'author' => '',
			'ganre' => '',	            
			'publish' => '',
			'time' => '',
			'reader' => '',
			'cycle' => '',
			'numCycle' => ''
		 );

		$prevKey = '';
		foreach ($data as $d) {
			$parts = explode(':', ($d));

			foreach ($keys as $k => $v) {
				if($prevKey == 'description')
				{
					if(count($parts) > 1)
					{
						$result['description'] =  $result['description'] . trim($parts[1]);	
						$prevKey = '';
					}
				}

		                foreach ($v as $val) {
					if (trim($parts[0]) == $val) {
		                        	if ($k == 'time') {
	                		            @$result[$k] = sprintf("%s:%s:%s", trim($parts[1]), trim($parts[2]), trim($parts[3]));
			                        } else {
                			            $result[$k] = trim($parts[1]);
                       				}

						$prevKey = $k;
                    			}
                		}
            		}
        	}

		if (isset($result['alname']) && isset($result['afname'])) {
			$result['author'] = $result['afname'] . ' ' . $result['alname'];
			unset($result['afname']);
			unset($result['alname']);
        	}

	        return $result;
    	}	

	public function getData() 
	{
	    $content = $this->loadData(array(array('from' => '/\<br\>/', 'to' => '(br)')));

	    $bookinfoObj = $this->find(array('/html/body/div[1]/div/div/main/div[2]/article/div[1]/div[1]',
		    			'//*[@id="dle-content"]/article/div[1]/div[1]',
					'/html/body/div[1]/div/div[2]/main/div[2]/div/article/div[1]/div[1]',
					'/html/body/div[1]/div/div[2]/main/div[2]/div/article/div[1]/div[1]'));//->textContent;

	    //echo $content;	
	    //var_dump($bookinfoObj);

	    @$bookinfo = $bookinfoObj->textContent;

	    //var_dump($bookinfo);

	    if(!$bookinfo)
	    {
		    $bookinfo = $bookinfoObj->nodeValue;
	    }
			    

	    //var_dump($bookinfo);
		
	    $bookinfo = explode("\n", $bookinfo)[0];

	    //print_r($bookinfo);

	    $result = $this->getDetailsBook(explode("(br)",$bookinfo));

	    //print_r($result);

		$result['name'] = ($this->find(array("/html/body/div[1]/div/div/main/div[2]/article/div[1]/header/h1",'//*[@id="dle-content"]/article/div[1]/header/h1'))->nodeValue);
		$result['source'] = $this->url;
		$imgUrl = $this->find(array('//*[@id="dle-content"]/article/div[1]/div[1]/img',
					'/html/body/div[1]/div/div[2]/main/div[2]/div/article/div[1]/div[1]/img'))->getAttribute('data-src');


		if(substr($imgUrl, 0, 4 ) === "http")
		{
			$result['img'] = $imgUrl;
		}
		else
		{	
			$result['img'] = sprintf(AudioBooOrg::URL, $imgUrl);
		}		

		$result['torrent'] = $this->find(array('//*[@id="dle-content"]/article/div[1]/div[2]/ul/div[2]/a'))->getAttribute('href');
	
		$jsdata = $this->find(array('//*[@id="player-moonwalk"]/script'));

		if(isset($jsdata))
		{
			$jsdata = $jsdata->textContent;
			$jsdata = htmlentities($jsdata);
			$jsdata = str_replace("&nbsp;",'', $jsdata);
			$jsdata = str_replace("&quot;", "'", $jsdata);
			
			$jsdata = str_replace("\r\n", "", $jsdata);
			$jsdata = str_replace("\n", "", $jsdata);
			$jsdata = str_replace("\t", "", $jsdata);

			//echo 'jsdata' . $jsdata;

			//$req = "/Playerjs\(\{[ ]*id[ ]*:[ ]*\'player\'[ ]*,[ ]*file[ ]*:[ ]*([ 0-9a-zA-Zа-яёА-ЯЁ:\"\,\[\{\}\/\._-]+})/iu";
			//$req = "/Playerjs\(\{[ ]*id[ ]*:[ ]*\'player\'[ ]*,[ ]*file[ ]*:[ ]*([\[{\' 0-9a-zA-Zа-яёА-ЯЁ:,\/\._}\]]+)/iu";
			$req = "/Playerjs\(\{[ ]*id[ ]*:[ ]*\'player\'[ ]*,[ ]*file[ ]*:[ ]*([\[{\' 0-9a-zA-Zа-яёА-ЯЁ:;&,\(\)\/\._\-}\]\=\?\%\!\«\»]+)[ ]*\}\)/iu";
			@preg_match($req, $jsdata, $matches);

			//print_r($matches);

			$jsonText = trim($matches[1]);
			$jsonText = str_replace("'",'"', $jsonText);

			@$result['playList'] = strlen($jsonText) > 0 ? $jsonText  : '';
			$playLst = json_decode($jsonText); 

			//print_r($playLst);

			$file = array();
			if(is_array($playLst))
			{
				foreach ($playLst as $obj) {

					$f = $obj->file;

					//echo $f;

                                        @preg_match("/\/engine\/go\.php\?url=([a-zA-Z0-9=]+)/", $f, $mf);

                                        //print_r($mf);
                                        if(is_array($mf) && count($mf) > 1)
                                        {
                                                $f = base64_decode($mf[1]);
                                        }


					$info = array('title' => $obj->title, 'file' => $f);
					$file[] = $info;
					}
			}	

			$result['fileLst'] = $file;	
		}
		else
		{
			$frmUrl = $this->find(array('//*[@id="dle-content"]/div/div[2]/div[1]/div[1]/object'))->getAttribute('data');
			$frmContent = $this->loadData(array(array('from' => '/\<br \/\>/', 'to' => '(br)')), $frmUrl);
			$jsdata = $this->find(array('//*[@id="wrap"]/input[1]'))->getAttribute('value');
			$jsdata = str_replace("\n", "", $jsdata);
			$jsdata = str_replace("\t", "", $jsdata);
			$jsdata = trim($jsdata);
			@$playLst = json_decode($jsdata);
			
			$file = array();
			if(is_array($playLst))
			{
					foreach ($playLst as $obj) {
					$info = array('title' => $obj->title, 'file' => sprintf(AudioBooRu::PLAY_URL, $obj->sources[0]->file));
					$file[] = $info;
					}
			}	
			
			$result['fileLst'] = $file;
		}

		//print_r($result);

	        return $result;
    }

}
