<?php

error_reporting(E_ALL);
ini_set("display_errors", 1);

require_once 'baseParser.php';
require_once 'bookParserInterface.php';

class AudioBooRu extends BaseParser implements iParserInterface {

	CONST URL = "http://audioboo.ru%s";
	CONST PLAY_URL = "https://archive.org%s";

	public function __construct($url) {
        	parent::__construct($url);
	}


	private function getDetailsBook($data) {
        	$keys = array(
            		'year' => array('Год выпуска','Год выпуска аудиокниги'),
	            	'afname' => array('Имя автора'),
        	    	'alname' => array('Фамилия автора'),
            		'author' => array('Автор'),
	            	'ganre' => array('Жанр'),
        	    	'publish' => array('Прочитано по изданию','Издательство'),
            		'time' => array('Время звучания','Продолжительность'),
	            	'reader' => array('Исполнитель'),
			'cycle' => array('Цикл/серия'),
			'numCycle' => array('Номер в серии/цикле','Номер книги'),
		    	'description' => array('Описание')
        	);

	        $result = array(
			'year' => '',
			'author' => '',
			'ganre' => '',	            
			'publish' => '',
			'time' => '',
			'reader' => '',
			'cycle' => '',
			'numCycle' => ''
		 );

		$prevKey = '';
		foreach ($data as $d) {
			$parts = explode(':', ($d));

			foreach ($keys as $k => $v) {
				if($prevKey == 'description')
				{
					if(count($parts) > 1)
					{
						$result['description'] =  $result['description'] . trim($parts[1]);	
						$prevKey = '';
					}
				}

		                foreach ($v as $val) {
					if (trim($parts[0]) == $val) {
		                        	if ($k == 'time') {
	                		            @$result[$k] = sprintf("%s:%s:%s", trim($parts[1]), trim($parts[2]), trim($parts[3]));
			                        } else {
                			            $result[$k] = trim($parts[1]);
                       				}

						$prevKey = $k;
                    			}
                		}
            		}
        	}

		if (isset($result['alname']) && isset($result['afname'])) {
			$result['author'] = $result['afname'] . ' ' . $result['alname'];
			unset($result['afname']);
			unset($result['alname']);
        	}

	        return $result;
    	}	

	public function getData() 
	{
	    $content = $this->loadData(array(array('from' => '/\<br \/\>/', 'to' => '(br)')));

	    $bookinfo = $this->find(array('//*[@id="dle-content"]/div/div[3]/div','//*[@id="dle-content"]/div/div[2]/div',
	    				'/html/body/div[1]/div/div/main/div[2]/article/div[1]/div[1]'))->textContent;
		
		$bookinfo = explode("\n", $bookinfo)[0];

		$result = $this->getDetailsBook(explode("(br)",$bookinfo));

		$result['name'] = ($this->find("//*[@id='dle-content']/div/h1")->nodeValue);
		$result['source'] = $this->url;
		$imgUrl = trim($this->find('//*[@id="dle-content"]/div/div[1]/div[1]/img')->getAttribute('src'));
		if(substr($imgUrl, 0, 4 ) === "http")
		{
			$result['img'] = $imgUrl;
		}
		else
		{	
			$result['img'] = sprintf(AudioBooRu::URL, $imgUrl);
		}		

		$result['torrent'] = $this->find(array('//*[@class="full-news-content"]/div/table/tr[5]/td[2]/font/a[2]','//*[@id="dle-content"]/div/div[3]/noindex/table/tr[5]/td[2]/font/a[2]','//*[@id="dle-content"]/div/div[2]/noindex/table/tr[5]/td[2]/font/a[2]'))->getAttribute('href');
	
		$jsdata = $this->find(array('//*[@id="dle-content"]/div/div[3]/noindex/center[1]/script',
			'//*[@id="dle-content"]/div/div[2]/noindex/center[1]/script',
			'//*[@id="dle-content"]/div/div[3]/noindex/center/script'));

		if(isset($jsdata))
		{
			$jsdata = $jsdata->textContent;
			$jsdata = str_replace("\n", "", $jsdata);
			$jsdata = str_replace("\t", "", $jsdata);

			//echo $jsdata;

			$req = "/Playerjs\(\{[ ]*id[ ]*:[ ]*\"player\"[ ]*,[ ]*file[ ]*:[ ]*([ 0-9a-zA-Zа-яёА-ЯЁ:\'\"\,\[\{\}\/\._-]+})/iu";
			@preg_match($req, $jsdata, $matches);

			@$result['playList'] = strlen($matches[1]) > 0 ? $matches[1] . ']' : '';
			@$playLst = json_decode($matches[1] . ']'); 


			$file = array();
			if(is_array($playLst))
			{
				foreach ($playLst as $obj) {

					$f = $obj->file;
					
					@preg_match("/\/engine\/go\.php\?url=([a-zA-Z0-9=]+)/", $f, $mf);

					print_r($mf);
					if(is_array($mf))
					{
						$f = $mf[1];
					}

					$info = array('title' => $obj->title, 'file' => $f);
					$file[] = $info;
					}
			}	

			$result['fileLst'] = $file;	
		}
		else
		{
			$frmUrl = $this->find(array('//*[@id="dle-content"]/div/div[2]/div[1]/div[1]/object'))->getAttribute('data');
			$frmContent = $this->loadData(array(array('from' => '/\<br \/\>/', 'to' => '(br)')), $frmUrl);
			$jsdata = $this->find(array('//*[@id="wrap"]/input[1]'))->getAttribute('value');
			$jsdata = str_replace("\n", "", $jsdata);
			$jsdata = str_replace("\t", "", $jsdata);
			$jsdata = trim($jsdata);
			@$playLst = json_decode($jsdata);
			
			$file = array();
			if(is_array($playLst))
			{
					foreach ($playLst as $obj) {
					$info = array('title' => $obj->title, 'file' => sprintf(AudioBooRu::PLAY_URL, $obj->sources[0]->file));
					$file[] = $info;
					}
			}	
			
			$result['fileLst'] = $file;
		}

	        return $result;
    }

}
