<?php

require_once 'baseParser.php';
require_once 'bookParserInterface.php';

class AudioBooRu extends BaseParser implements iParserInterface {

	CONST URL = "http://audioboo.ru%s";
	CONST PLAY_URL = "https://archive.org%s";

	public function __construct($url) {
        	parent::__construct($url);
	}


	private function getDetailsBook($data) {
        	$keys = array(
            		'year' => array('Год выпуска'),
	            	'afname' => array('Имя автора'),
        	    	'alname' => array('Фамилия автора'),
            		'author' => array('Автор'),
	            	'ganre' => array('Жанр'),
        	    	'publish' => array('Прочитано по изданию','Издательство'),
            		'time' => array('Время звучания'),
	            	'reader' => array('Исполнитель'),
			'cycle' => array('Цикл/серия'),
			'numCycle' => array('Номер в серии/цикле','Номер книги'),
		    	'description' => array('Описание')
        	);

	        $result = array(
			'year' => '',
			'author' => '',
			'ganre' => '',	            
			'publish' => '',
			'time' => '',
			'reader' => '',
			'cycle' => '',
			'numCycle' => ''
		 );

		$prevKey = '';
		foreach ($data as $d) {
			$parts = explode(':', ($d));

			foreach ($keys as $k => $v) {
				if($prevKey == 'description')
				{
					if(count($parts) > 1)
					{
						$result['description'] =  $result['description'] . trim($parts[1]);	
						$prevKey = '';
					}
				}

		                foreach ($v as $val) {
					if (trim($parts[0]) == $val) {
		                        	if ($k == 'time') {
	                		            @$result[$k] = sprintf("%s:%s:%s", trim($parts[1]), trim($parts[2]), trim($parts[3]));
			                        } else {
                			            $result[$k] = trim($parts[1]);
                       				}

						$prevKey = $k;
                    			}
                		}
            		}
        	}

		if (isset($result['alname']) && isset($result['afname'])) {
			$result['author'] = $result['afname'] . ' ' . $result['alname'];
			unset($result['afname']);
			unset($result['alname']);
        	}

	        return $result;
    	}	

	public function getData() {
	        $content = $this->loadData(array(array('from' => '/\<br \/\>/', 'to' => '(br)')));

        	$bookinfo = $this->xpath->query('/html/body/div[2]/div[4]/div/div/div/div[3]/div[1]')->item(0)->textContent;
		$bookinfo = explode("\n", $bookinfo)[0];

		$result = $this->getDetailsBook(explode("(br)",$bookinfo));

		$result['name'] = ($this->xpath->query("//*[@id='dle-content']/div/h1")->item(0)->nodeValue);
		$result['source'] = $this->url;
		$result['img'] = sprintf(AudioBooRu::URL, trim($this->xpath->query('//*[@id="dle-content"]/div/div[1]/div[1]/img')->item(0)->getAttribute('src')));


		$jsdata = $this->xpath->query('//*[@id="dle-content"]/div/div[3]/noindex/center[1]/script')->item(0)->textContent;

		$jsdata = str_replace("\n", "", $jsdata);
		$jsdata = str_replace("\t", "", $jsdata);
	
		$req = "/Playerjs\(\{[ ]*id[ ]*:[ ]*\"player\"[ ]*,[ ]*file[ ]*:[ ]*([ a-zA-Z0-9:\"\,\[\{\}\/\._]+})/";//"/Playerjs\((\{[ a-zA-Z0-9:\"\,\[\{\}\/\._]+})/";
		@preg_match($req, $jsdata, $matches);

		@$result['playList'] = $matches[1] . ']';
		@$playLst = json_decode($matches[1] . ']'); 


		$file = array();
        	foreach ($playLst as $obj) {
			$info = array('title' => $obj->title, 'file' => $obj->file);
			$file[] = $info;
        	}	

		$result['fileLst'] = $file;	


	        return $result;
    }

}
