<?php

require_once 'baseParser.php';
require_once 'bookParserInterface.php';

class AudiobookRmailPro extends BaseParser implements iParserInterface {

    public function __construct($url) {
        parent::__construct($url);
    }

    public function getData() {
        $result = array(
            'publish' => '',
            'cycle' => '',
            'numCycle' => '',
            'time' => '',
            'year' => '',
            'reader' => ''
        );

        $result['source'] = $this->url;

        $content = $this->loadData();

        $result['name'] = trim(utf8_decode($this->xpath->query('/html/body/div[1]/div/div[2]/main/article/div/header/h1')->item(0)->textContent));
        $result['img'] = trim($this->xpath->query('/html/body/div[1]/div/div[2]/main/article/div/div/figure/img')->item(0)->getAttribute('src'));
        $result['description'] = trim(utf8_decode($this->xpath->query('/html/body/div[1]/div/div[2]/main/article/div/div/p[2]/span')->item(0)->textContent));
        $result['author'] = trim(utf8_decode($this->xpath->query('/html/body/div[1]/div/div[2]/main/article/div/div/h4/a')->item(0)->textContent));
        $result['ganre'] = trim(utf8_decode($this->xpath->query('/html/body/div[1]/div/div[2]/main/article/div/div/p[2]/a/strong')->item(0)->textContent));

        $play = $this->xpath->query('/html/body/div[1]/div/div[2]/main/article/div/div/script')->item(0)->textContent;
        $play = preg_replace(array("/\\n/", "/ /"), '', trim($play));
        $req = "/varflashvars={config:\"[0-9a-zA-Z\:\/\%\.\-\_\?]+\",file\:\"([0-9a-zA-Z\:\/\%\.\-\_\?]+)\"/";
        preg_match($req, $play, $matches);
        $result['playList'] = urldecode($matches[1]);
        $filesData = AppHelper::loaData($result['playList']);

        $DOM = new DOMDocument;

        libxml_use_internal_errors(true);

        if (!$DOM->loadHTML($filesData)) {
            $errors = "";
            foreach (libxml_get_errors() as $error) {
                $errors.=$error->message . "<br/>";
            }

            libxml_clear_errors();
            print "libxml errors:<br>$errors";
            return;
        }

        $xpath = new DOMXPath($DOM);

        $nodes = $xpath->query('//playlist/tracklist/track');

        $arr = array();
        foreach ($nodes as $node) {
            $arr[] = array(
                'title' => trim($node->getElementsByTagName('annotation')->item(0)->firstChild->nodeValue),
                'file' => trim($node->getElementsByTagName('location')->item(0)->firstChild->nodeValue)
            );
        }

        $result['fileLst'] = $arr;

        return $result;
    }

}
