<?php

require_once 'baseParser.php';
require_once 'bookParserInterface.php';


class AudioknigiClub extends BaseParser implements iParserInterface
{
    CONST PLAYLIST_URL = "https://audioknigi.club/rest/bid/%d";
    
	public function __construct($url)
	{
		parent::__construct($url);
	}

	public function getData()
	{
		$result = array(
			'publish' => '',
			'cycle' => '',
			'numCycle' => '',
		);
		
		$content = $this->loadData();
		
		$req = '/\$\(document\)\.audioPlayer\(([0-9]+),[0-9]+\)\;/';
		
		preg_match($req, $content, $matches);
		$result['playList'] = sprintf(AudioknigiClub::PLAYLIST_URL, $matches[1]);
		$result['source'] = $this->url;
		$year = $this->xpath->query("//*[@id='content']/div/article/div[2]/div[2]/div[2]/div[2]/a")->item(0)->getAttribute('href');
		$req = '/\/([0-9]+)$/';
		preg_match($req, $year, $matches);
		$result['year'] = $matches[1];
		$result['time'] = trim($this->xpath->query("//*[@id='content']/div/article/div[2]/div[2]/div[2]/div[3]")->item(0)->textContent);
		$result['ganre'] = utf8_decode(trim(trim($this->xpath->query("//*[@id='content']/div/article/header/div/div/a")->item(0)->textContent)));
		$result['reader'] = utf8_decode(trim(trim($this->xpath->query("//*[@id='content']/div/article/div[2]/div[2]/div[1]/div[3]/a")->item(0)->textContent)));
		$result['author'] = utf8_decode(trim(trim($this->xpath->query("//*[@id='content']/div/article/div[2]/div[2]/div[1]/div[2]/a/span")->item(0)->textContent)));
		$result['img'] = $this->xpath->query("//*[@id='content']/div/article/div[1]/div[2]/img")->item(0)->getAttribute('src');
		$result['name'] = utf8_decode(trim($this->xpath->query("//*[@id='content']/div/article/header/h1")->item(0)->nodeValue));
		$result['description'] = utf8_decode(trim($this->xpath->query("//*[@id='content']/div/article/div[3]")->item(0)->textContent));
		
		$filesData = AppHelper::loaData($result['playList']);
		$filesObj = json_decode($filesData);
	
		$arr = array();
		foreach($filesObj as $obj)
		{
			$arr[] = array('title' => $obj->title, 'file' => $obj->mp3);
		}

		$result['fileLst'] = $arr;
		
		return $result;
	}
}

