<?php

require_once 'baseParser.php';
require_once 'bookParserInterface.php';

class AudioknigiOnline extends BaseParser implements iParserInterface {

    public function __construct($url) {
        parent::__construct($url);
    }

    private function getDetailsBook($data) {
        $keys = array(
            'year' => array('Год выпуска'),
            'afname' => array('Имя автора'),
            'alname' => array('Фамилия автора'),
            'author' => array('Автор'),
            'ganre' => array('Жанр'),
            'publish' => array('Издательство'),
            'time' => array('Время звучания', 'Продолжительность'),
            'reader' => array('Исполнитель'),
			'cycle' => array('Серия/Цикл','Цикл/серия'),
			'numCycle' => array('Номер в серии/цикле','Номер книги')
        );

        $result = array(
            'year' => '',
            'author' => '',
            'ganre' => '',
            'publish' => '',
            'time' => '',
            'reader' => '',
			'cycle' => '',
			'numCycle' => '',
        );

        foreach ($data as $d) {
            $parts = explode(':', utf8_decode($d->textContent));

            foreach ($keys as $k => $v) {
                foreach ($v as $val) {
                    if (trim($parts[0]) == $val) {
                        if ($k == 'time') {
                            @$result[$k] = sprintf("%s:%s:%s", trim($parts[1]), trim($parts[2]), trim($parts[3]));
                        } else {
                            $result[$k] = trim($parts[1]);
                        }
                    }
                }
            }
        }

        if (isset($result['alname']) && isset($result['afname'])) {
            $result['author'] = $result['afname'] . ' ' . $result['alname'];

            unset($result['afname']);
            unset($result['alname']);
        }

        return $result;
    }

    public function getData() {
        $content = $this->loadData();

        $req = '/xhr\.open\(\"get\", \"([0-9a-zA-Z\:\/\.\-]+)/';
        preg_match($req, $content, $matches);
        $playlist = $matches[1];

        $details = $this->xpath->query("//div[@class='entry-content']//ul/li");
        $result = $this->getDetailsBook($details);
	$result['source'] = $this->url;
        $result['description'] = utf8_decode($this->xpath->query("//div[@class='entry-content']//p")->item(0)->textContent);
        $result['name'] = utf8_decode($this->xpath->query("//h1[@class='entry-title']")->item(0)->nodeValue);
        //$result['img'] = $this->xpath->query("//div[@class='entry-content']//img")->item(2)->getAttribute('src');
	$img = $this->xpath->query("//div[@class='entry-content']//img")->item(0)->getAttribute('src');

	if(substr($img, 0, 7 ) !== "http://" || substr($img, 0, 7 ) !== "https://")
        {
		$img = $this->protocol . ":" . $img;
	}

	$result['img'] = $img;

	if(substr($playlist, 0, 7 ) !== "http://" || substr($playlist, 0, 7 ) !== "https://")
	{
		$playlist = $this->protocol . ":" . $playlist;
	}
	
	$result['playList'] = $playlist;

        $filesData = AppHelper::loaData($playlist);
        $filesObj = json_decode($filesData);
        
        $arr = array();
        foreach($filesObj->playlist as $obj)
        {
            $arr[] = array('title' => $obj->comment, 'file' => $obj->file);
        }
        
        $result['fileLst'] = $arr;
        
        return $result;
    }
}
