<?php

require_once ENGINE_PATH . '../Helpers/AppHelper.php';

class BaseParser
{
	protected $xpath;
	protected $url;
	protected $protocol;

	protected function __construct($url)
	{
		$this->url = trim($url);
		$this->protocol = parse_url($url)['scheme'];
	}

	protected function find($expression)
	{
		if(is_array($expression))
		{
			foreach($expression as $val)
			{
				//var_dump($val);
				$res =  $this->xpath->query($val)->item(0);
				
				if($res != null)
				{
					return $res;
				}
			}
		}
		else
		{
			return $this->xpath->query($expression)->item(0);
		}
	}

	protected function loadData($replace=false, $url=false)
	{
		if($url)
		{
			$this->url = trim($url);
		}
		
		$content = AppHelper::loaData($this->url);

		$content = preg_replace("/“|”|&#8221;|&#8220;/","\"", $content);
		$content = preg_replace("/&#8211;/", "-", $content);
		$content = preg_replace("/&nbsp;/", " ", $content);
		$content = preg_replace("/&laquo;/", "\"", $content);
		$content = preg_replace("/&raquo;/", "\"", $content);
		$content = preg_replace("/&#171;/", "\"", $content);
		$content = preg_replace("/&#187;/", "\"", $content);

		//$content = preg_replace("/\<br \/\>/","(br)",$content);
		if($replace)
		{
			foreach($replace as $val)
			{
				$content = preg_replace($val['from'], $val['to'], $content);
			}
		}		


		$DOM = new DOMDocument;

		libxml_use_internal_errors(true);

		if (!$DOM->loadHTML($content))
		{
			$errors="";
			foreach (libxml_get_errors() as $error)  
			{
					$errors.=$error->message."<br/>"; 
			}

			libxml_clear_errors();
			print "libxml errors:<br>$errors";
			return;
		}

		$this->xpath = new DOMXPath($DOM);

		return $content;
	}
} 
