<?php

require_once 'audioknigiOnline.php';
require_once 'abookFm.php';
require_once 'audioknigiClub.php';
require_once 'asbookNet.php';
require_once 'audiobookRmailPro.php';
require_once 'audioBooRu.php';
require_once 'audioBooOrg.php';

class BooksFactory
{
	public static  function Book($url)
	{
		$req = '/(http:\/\/|https:\/\/)([0-9a-zA-Z\.\-]*)/';
		preg_match($req, $url, $matches);
		$parser = false;
		
		switch($matches[2])
		{
			case 'www.audioknigi-online.com':
				$parser = new AudioknigiOnline($url);
			break;
			case 'abook.fm':
				$parser = new AbookFm($url);
			break;
			case 'audioknigi.club':
				$parser = new AudioknigiClub($url);
			break;
			case 'asbook.net':
				$parser = new AsbookNet($url);
			break;
			case 'audiobook.rmail.pro':
				$parser = new AudiobookRmailPro($url);
			break;
			case 'audioboo.ru':
				$parser = new AudioBooRu($url);
			break;
			case 'audioboo.org':
				$parser = new AudioBooOrg($url);
			break;
		}

		return $parser->getData();
	}
}
