#!/usr/bin/php
<?php

ini_set('memory_limit', '256000M');

require_once 'config.php';
require_once ENGINE_PATH . '../Model/AdminBooksDb_Model.php';
require_once ENGINE_PATH . '../Helpers/AppHelper.php';


$path = sprintf("%s/origin/", IMAGEFILE_PATH);
$pathSmall = sprintf("%s/small/", IMAGEFILE_PATH);

$db = new AdminBooksDB_Model();

$fileData = $db->getQueueFile();

if (isset($fileData['lst'])) 
{

	$bookStatus = 1;
    $bookid = $fileData['bookid'];
	$img = $fileData['img'];

    $folder = sprintf("%s/%s", DATAFILE_PATH, $bookid);
    if (!is_dir($folder)) 
	{
        mkdir($folder);
    }

    $db->setBookStatus($bookid, $bookStatus);

	if(count($fileData['lst']) > 0)
	{
		foreach ($fileData['lst'] as $file) 
		{
			$db->setFileStatus($file['id'], 1);

			$f = sprintf("%s/%s.mp3", $folder, $file['fileNum']);
			echo 'Try to load file: ' . $file['source'] . ' to ' . $f;
			
			if($fileData['status'] == 4)
			{
				AppHelper::moveFile($file['source'], $f);
			}
			else
			{
				$cont = AppHelper::loaData($file['source']);

				file_put_contents($f, $cont);
			}
			//AppHelper::loadFile($file['source'], $f);

			$db->setFileStatus($file['id']);
		}

		$bookStatus = 2;
	}
	else if(strlen($fileData['torrent']) > 0)
	{
		//AppHelper::addTorrent($fileData['torrent']);
		$bookStatus = 3;
	}

	if($bookStatus != 3)
	{
		$cont = AppHelper::loaData($img);

		if(strpos($cont, "<html>") === false)
		{       
			$file = $path . $bookid . '.png';
					
			echo 'try download file: ' . $img . "\n";
			file_put_contents($file, $cont);
			echo 'downloaded to: ' . $file . "\n";
					
			$fileSmall = $pathSmall . $bookid . '.png';
			echo $fileSmall;
					
			$rimg = resize_image($file, 120, 120);
					
			imagejpeg($rimg, $fileSmall, 70);
		}
	}

    $db->setBookStatus($bookid, $bookStatus);
}

function resize_image($file, $w, $h, $crop=FALSE) 
{
    list($width, $height) = getimagesize($file);
    $r = $width / $height;
    if ($crop) 
	{
        if ($width > $height) {
            $width = ceil($width-($width*abs($r-$w/$h)));
        } else {
            $height = ceil($height-($height*abs($r-$w/$h)));
        }
        $newwidth = $w;
        $newheight = $h;
    } 
	else if ($w/$h > $r) 
	{
            $newwidth = $h*$r;
            $newheight = $h;
    } 
	else 
	{
            $newheight = $w/$r;
            $newwidth = $w;
    }
    
    $src = imagecreatefromjpeg($file);
    $dst = imagecreatetruecolor($newwidth, $newheight);
    imagecopyresampled($dst, $src, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);

    return $dst;
}

